package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineLocationPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_3195;
import net.minecraft.class_4550;
import net.minecraft.class_4551;
import net.minecraft.class_4552;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7871;

@Mixin(class_2090.class)
public abstract class LocationPredicateMixin implements ZineLocationPredicate {

    @Shadow @Final @Mutable
    private Optional<class_2090.class_8747> position;

    @Shadow @Final @Mutable
    private Optional<class_6885<class_1959>> biomes;

    @Shadow @Final @Mutable
    private Optional<class_6885<class_3195>> structures;

    @Shadow @Final @Mutable
    private Optional<class_5321<class_1937>> dimension;

    @Shadow @Final @Mutable
    private Optional<Boolean> smokey;

    @Shadow @Final @Mutable
    private Optional<class_4552> light;

    @Shadow @Final @Mutable
    private Optional<class_4550> block;

    @Shadow @Final @Mutable
    private Optional<class_4551> fluid;

    @Shadow @Final @Mutable
    private Optional<Boolean> canSeeSky;

    @Override
    public void zine$setPosition(class_2096.class_2099 x, class_2096.class_2099 y, class_2096.class_2099 z) {
        this.position = class_2090.class_8747.method_53185(x, y, z);
    }

    @Override
    public void zine$clearPosition() {
        this.position = Optional.empty();
    }

    @Override
    public void zine$setBiomes(@Nullable class_6885<class_1959> biomes) {
        this.biomes = Optional.ofNullable(biomes);
    }

    @Override
    public void zine$addBiome(class_6880<class_1959> biome) {
        if(this.biomes.isPresent()) {
            this.biomes = Optional.of(ZineUtil.mergeValue(this.biomes.get(), Function.identity(), biome));
            return;
        }
        this.biomes = Optional.of(class_6885.method_40246(biome));
    }

    @Override
    public void zine$addBiome(class_7871<class_1959> biomeLookup, class_5321<class_1959> biome) {
        if(this.biomes.isPresent()) {
            this.biomes = Optional.of(ZineUtil.mergeValue(this.biomes.get(), biomeLookup::method_46747, biome));
            return;
        }
        this.biomes = Optional.of(class_6885.method_40245(biomeLookup::method_46747, biome));
    }

    @Override
    public void zine$addBiomes(class_6885<class_1959> biomes) {
        if(this.biomes.isPresent()) {
            this.biomes = Optional.of(ZineUtil.mergeValues(this.biomes.get(), biomes));
            return;
        }
        this.biomes = Optional.of(biomes);
    }

    @Override
    public void zine$addBiomes(class_7871<class_1959> biomeLookup, Collection<class_5321<class_1959>> biomes) {
        if(this.biomes.isPresent()) {
            this.biomes = Optional.of(ZineUtil.mergeValues(this.biomes.get(), biomeLookup::method_46747, biomes));
            return;
        }
        this.biomes = Optional.of(class_6885.method_40244(biomeLookup::method_46747, biomes));
    }

    @Override
    public void zine$setStructures(@Nullable class_6885<class_3195> structures) {
        this.structures = Optional.ofNullable(structures);
    }

    @Override
    public void zine$addStructure(class_6880<class_3195> structure) {
        if(this.structures.isPresent()) {
            this.structures = Optional.of(ZineUtil.mergeValue(this.structures.get(), Function.identity(), structure));
            return;
        }
        this.structures = Optional.of(class_6885.method_40246(structure));
    }

    @Override
    public void zine$addStructure(class_7871<class_3195> structureLookup, class_5321<class_3195> structure) {
        if(this.structures.isPresent()) {
            this.structures = Optional.of(ZineUtil.mergeValue(this.structures.get(), structureLookup::method_46747, structure));
            return;
        }
        this.structures = Optional.of(class_6885.method_40245(structureLookup::method_46747, structure));
    }

    @Override
    public void zine$addStructures(class_7871<class_3195> structureLookup, Collection<class_5321<class_3195>> structures) {
        if(this.structures.isPresent()) {
            this.structures = Optional.of(ZineUtil.mergeValues(this.structures.get(), structureLookup::method_46747, structures));
            return;
        }
        this.structures = Optional.of(class_6885.method_40244(structureLookup::method_46747, structures));
    }

    @Override
    public void zine$addStructures(class_6885<class_3195> structures) {
        if(this.structures.isPresent()) {
            this.structures = Optional.of(ZineUtil.mergeValues(this.structures.get(), structures));
            return;
        }
        this.structures = Optional.of(structures);
    }

    @Override
    public void zine$setDimension(@Nullable class_5321<class_1937> dimension) {
        this.dimension = Optional.ofNullable(dimension);
    }

    @Override
    public void zine$setSmokey(@Nullable Boolean smokey) {
        this.smokey = Optional.ofNullable(smokey);
    }

    @Override
    public void zine$setLight(@Nullable class_4552 light) {
        this.light = Optional.ofNullable(light);
    }

    @Override
    public void zine$setBlock(@Nullable class_4550 block) {
        this.block = Optional.ofNullable(block);
    }

    @Override
    public void zine$setFluid(@Nullable class_4551 fluid) {
        this.fluid = Optional.ofNullable(fluid);
    }

    @Override
    public void zine$setCanSeeSky(@Nullable Boolean canSeeSky) {
        this.canSeeSky = Optional.ofNullable(canSeeSky);
    }
}
