package com.eightsidedsquare.zine.mixin.predicate;

import com.eightsidedsquare.zine.common.predicate.ZineSlotsPredicate;
import com.eightsidedsquare.zine.common.util.ZineUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Map;
import net.minecraft.class_2073;
import net.minecraft.class_9348;
import net.minecraft.class_9350;

@Mixin(class_9350.class)
public abstract class SlotsPredicateMixin implements ZineSlotsPredicate {

    @Shadow @Final @Mutable
    private Map<class_9348, class_2073> slots;

    @Override
    public void zine$setSlots(Map<class_9348, class_2073> slots) {
        this.slots = slots;
    }

    @Override
    public void zine$addSlot(class_9348 slotRange, class_2073 itemPredicate) {
        this.slots = ZineUtil.putOrUnfreeze(this.slots, slotRange, itemPredicate);
    }
}
