package com.eightsidedsquare.zine.mixin.structure;

import com.eightsidedsquare.zine.common.util.ZineUtil;
import com.eightsidedsquare.zine.common.world.structure.ZineListPoolElement;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_3782;
import net.minecraft.class_3784;

@Mixin(class_3782.class)
public abstract class ListPoolElementMixin implements ZineListPoolElement {

    @Shadow @Final @Mutable
    private List<class_3784> elements;

    @Override
    public List<class_3784> zine$getElements() {
        return this.elements;
    }

    @Override
    public void zine$setElements(List<class_3784> elements) {
        this.elements = elements;
    }

    @Override
    public void zine$addElement(class_3784 element) {
        this.elements = ZineUtil.addOrUnfreeze(this.elements, element);
    }

    @Override
    public void zine$addElements(List<class_3784> elements) {
        this.elements = ZineUtil.addAllOrUnfreeze(this.elements, elements);
    }
}
