package com.eightsidedsquare.zine.mixin.structure;

import com.eightsidedsquare.zine.common.world.structure.ZineRuleStructureProcessor;
import com.google.common.collect.ImmutableList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_3821;
import net.minecraft.class_3826;

@Mixin(class_3826.class)
public abstract class RuleStructureProcessorMixin implements ZineRuleStructureProcessor {

    @Shadow @Final @Mutable
    private ImmutableList<class_3821> rules;

    @Override
    public ImmutableList<class_3821> zine$getRules() {
        return this.rules;
    }

    @Override
    public void zine$setRules(ImmutableList<class_3821> rules) {
        this.rules = rules;
    }

    @Override
    public void zine$addRule(class_3821 rule) {
        this.rules = ImmutableList.<class_3821>builder().addAll(this.rules).add(rule).build();
    }

    @Override
    public void zine$addRules(List<class_3821> rules) {
        this.rules = ImmutableList.<class_3821>builder().addAll(this.rules).addAll(rules).build();
    }
}
