package com.eightsidedsquare.zine.mixin.structure;

import com.eightsidedsquare.zine.common.world.structure.ZineSinglePoolElement;
import com.mojang.datafixers.util.Either;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_5497;
import net.minecraft.class_6880;
import net.minecraft.class_9822;

@Mixin(class_3781.class)
public abstract class SinglePoolElementMixin implements ZineSinglePoolElement {

    @Shadow @Final @Mutable
    protected Either<class_2960, class_3499> location;

    @Shadow @Final @Mutable
    protected class_6880<class_5497> processors;

    @Shadow @Final @Mutable
    protected Optional<class_9822> overrideLiquidSettings;

    @Override
    public void zine$setTemplate(class_2960 template) {
        this.location = Either.left(template);
    }

    @Override
    public void zine$setTemplate(class_3499 template) {
        this.location = Either.right(template);
    }

    @Override
    public Either<class_2960, class_3499> zine$getTemplate() {
        return this.location;
    }

    @Override
    public class_6880<class_5497> zine$getProcessors() {
        return this.processors;
    }

    @Override
    public void zine$setProcessors(class_6880<class_5497> processors) {
        this.processors = processors;
    }

    @Override
    public @Nullable class_9822 zine$getOverrideLiquidSettings() {
        return this.overrideLiquidSettings.orElse(null);
    }

    @Override
    public void zine$setOverrideLiquidSettings(@Nullable class_9822 overrideLiquidSettings) {
        this.overrideLiquidSettings = Optional.ofNullable(overrideLiquidSettings);
    }
}
