package com.eightsidedsquare.zine.mixin.structure;

import com.eightsidedsquare.zine.common.util.ZineUtil;
import com.eightsidedsquare.zine.common.world.structure.ZineStructurePool;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_6880;

@Mixin(class_3785.class)
public abstract class StructurePoolMixin implements ZineStructurePool {

    @Shadow @Final
    private ObjectArrayList<class_3784> elements;

    @Mutable @Shadow @Final
    private List<Pair<class_3784, Integer>> elementWeights;

    @Shadow
    private int highestY;

    @Shadow @Final @Mutable
    private class_6880<class_3785> fallback;

    @Override
    public ObjectArrayList<class_3784> zine$getElements() {
        return this.elements;
    }

    @Override
    public List<Pair<class_3784, Integer>> zine$getElementWeights() {
        return this.elementWeights;
    }

    @Override
    public void zine$addElement(class_3784 element, int weight) {
        if(weight < 1 || weight > 150) {
            return;
        }
        for(int i = 0; i < weight; i++) {
            this.elements.add(element);
        }
        this.elementWeights = ZineUtil.addOrUnfreeze(this.elementWeights, new Pair<>(element, weight));
        // Reset highest y so it can be recalculated
        this.highestY = Integer.MIN_VALUE;
    }

    @Override
    public void zine$setFallback(class_6880<class_3785> fallback) {
        this.fallback = fallback;
    }
}
