package com.eightsidedsquare.zine.mixin.structure;

import com.eightsidedsquare.zine.common.util.ZineUtil;
import com.eightsidedsquare.zine.common.world.structure.ZineStructureProcessorList;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;

import java.util.List;
import net.minecraft.class_3491;
import net.minecraft.class_5497;

@Mixin(class_5497.class)
public abstract class StructureProcessorListMixin implements ZineStructureProcessorList {

    @Shadow @Final @Mutable
    private List<class_3491> list;

    @Override
    public List<class_3491> zine$getProcessors() {
        return this.list;
    }

    @Override
    public void zine$setProcessors(List<class_3491> processors) {
        this.list = processors;
    }

    @Override
    public void zine$addProcessor(class_3491 processor) {
        this.list = ZineUtil.addOrUnfreeze(this.list, processor);
    }

    @Override
    public void zine$addProcessors(List<class_3491> processors) {
        this.list = ZineUtil.addAllOrUnfreeze(this.list, processors);
    }
}
