package com.eightsidedsquare.zine.mixin.text;

import com.eightsidedsquare.zine.common.text.CustomStyleAttribute;
import com.eightsidedsquare.zine.common.text.CustomStyleAttributeContainer;
import com.eightsidedsquare.zine.common.text.ZineMutableText;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5250.class)
public abstract class MutableTextMixin implements class_2561, ZineMutableText {

    @Shadow public abstract class_5250 setStyle(class_2583 style);

    @Shadow public abstract class_2583 method_10866();

    @Unique
    private boolean frozen = false;

    @Unique
    private class_5250 cast() {
        return (class_5250) (Object) this;
    }

    @Override
    public class_5250 zine$freeze() {
        this.frozen = true;
        return this.cast();
    }

    @Override
    public class_5250 zine$unfreeze() {
        this.frozen = false;
        return this.cast();
    }

    @Override
    public <T> class_5250 zine$withCustomAttribute(CustomStyleAttribute<T> attribute, T value) {
        return this.setStyle(this.method_10866().zine$withCustomAttribute(attribute, value));
    }

    @Override
    public class_5250 zine$withCustomAttributes(CustomStyleAttributeContainer attributes) {
        return this.setStyle(this.method_10866().zine$withCustomAttributes(attributes));
    }

    @Inject(method = "setStyle", at = @At("HEAD"), cancellable = true)
    private void zine$cancelSetStyleIfFrozen(class_2583 style, CallbackInfoReturnable<class_5250> cir) {
        if(this.frozen) {
            cir.setReturnValue(this.cast());
        }
    }

    @Inject(method = "append(Lnet/minecraft/text/Text;)Lnet/minecraft/text/MutableText;", at = @At("HEAD"), cancellable = true)
    private void zine$cancelAppendIfFrozen(class_2561 text, CallbackInfoReturnable<class_5250> cir) {
        if(this.frozen) {
            cir.setReturnValue(this.cast());
        }
    }
}
