/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.client.atlas;

import com.eightsidedsquare.zine.client.atlas.AtlasSourceUtil;
import com.eightsidedsquare.zine.client.atlas.TextureData;
import com.eightsidedsquare.zine.client.util.ConnectedPattern;
import com.eightsidedsquare.zine.client.util.ConnectedShape;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7771;
import net.minecraft.class_7948;
import org.slf4j.Logger;

@Environment(value=EnvType.CLIENT)
public class ConnectedTexturesAtlasSource
implements class_7948 {
    public static final MapCodec<ConnectedTexturesAtlasSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2960.field_25139.fieldOf("base_name").forGetter(ConnectedTexturesAtlasSource::getBaseName), (App)class_2960.field_25139.optionalFieldOf("all").forGetter(source -> Optional.of(source.allTexture)), (App)class_2960.field_25139.optionalFieldOf("corners").forGetter(source -> Optional.of(source.cornersTexture)), (App)class_2960.field_25139.optionalFieldOf("horizontal").forGetter(source -> Optional.of(source.horizontalTexture)), (App)class_2960.field_25139.optionalFieldOf("none").forGetter(source -> Optional.of(source.noneTexture)), (App)class_2960.field_25139.optionalFieldOf("vertical").forGetter(source -> Optional.of(source.verticalTexture))).apply((Applicative)instance, ConnectedTexturesAtlasSource::new));
    private static final Logger LOGGER = LogUtils.getLogger();
    private class_2960 baseName;
    private class_2960 allTexture;
    private class_2960 cornersTexture;
    private class_2960 horizontalTexture;
    private class_2960 noneTexture;
    private class_2960 verticalTexture;

    public ConnectedTexturesAtlasSource(class_2960 baseName, class_2960 allTexture, class_2960 cornersTexture, class_2960 horizontalTexture, class_2960 noneTexture, class_2960 verticalTexture) {
        this.baseName = baseName;
        this.allTexture = allTexture;
        this.cornersTexture = cornersTexture;
        this.horizontalTexture = horizontalTexture;
        this.noneTexture = noneTexture;
        this.verticalTexture = verticalTexture;
    }

    public ConnectedTexturesAtlasSource(class_2960 baseName, Optional<class_2960> allTexture, Optional<class_2960> cornersTexture, Optional<class_2960> horizontalTexture, Optional<class_2960> noneTexture, Optional<class_2960> verticalTexture) {
        this(baseName, allTexture.orElseGet(() -> baseName.method_48331("_all")), cornersTexture.orElseGet(() -> baseName.method_48331("_corners")), horizontalTexture.orElseGet(() -> baseName.method_48331("_horizontal")), noneTexture.orElseGet(() -> baseName.method_48331("_none")), verticalTexture.orElseGet(() -> baseName.method_48331("_vertical")));
    }

    public ConnectedTexturesAtlasSource(class_2960 baseName) {
        this(baseName, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public MapCodec<? extends class_7948> method_67288() {
        return CODEC;
    }

    public class_2960 getBaseName() {
        return this.baseName;
    }

    public void setBaseName(class_2960 baseName) {
        this.baseName = baseName;
    }

    public class_2960 getAllTexture() {
        return this.allTexture;
    }

    public void setAllTexture(class_2960 allTexture) {
        this.allTexture = allTexture;
    }

    public class_2960 getCornersTexture() {
        return this.cornersTexture;
    }

    public void setCornersTexture(class_2960 cornersTexture) {
        this.cornersTexture = cornersTexture;
    }

    public class_2960 getHorizontalTexture() {
        return this.horizontalTexture;
    }

    public void setHorizontalTexture(class_2960 horizontalTexture) {
        this.horizontalTexture = horizontalTexture;
    }

    public class_2960 getNoneTexture() {
        return this.noneTexture;
    }

    public void setNoneTexture(class_2960 noneTexture) {
        this.noneTexture = noneTexture;
    }

    public class_2960 getVerticalTexture() {
        return this.verticalTexture;
    }

    public void setVerticalTexture(class_2960 verticalTexture) {
        this.verticalTexture = verticalTexture;
    }

    public class_2960 getTexture(ConnectedShape shape) {
        return switch (shape) {
            default -> throw new MatchException(null, null);
            case ConnectedShape.ALL -> this.getAllTexture();
            case ConnectedShape.CORNER -> this.getCornersTexture();
            case ConnectedShape.HORIZONTAL -> this.getHorizontalTexture();
            case ConnectedShape.NONE -> this.getNoneTexture();
            case ConnectedShape.VERTICAL -> this.getVerticalTexture();
        };
    }

    public void method_47673(class_3300 resourceManager, class_7948.class_7949 regions) {
        EnumMap<ConnectedShape, TextureData> data = new EnumMap<ConnectedShape, TextureData>(ConnectedShape.class);
        int dataSize = -1;
        for (ConnectedShape shape : ConnectedShape.values()) {
            TextureData textureData = AtlasSourceUtil.open(resourceManager, this.getTexture(shape));
            int size = textureData.data().length;
            if (dataSize == -1) {
                dataSize = size;
            } else if (size != dataSize) {
                LOGGER.warn("Textures have different sizes: {} and {}", (Object)dataSize, (Object)size);
                throw new IllegalArgumentException();
            }
            data.put(shape, textureData);
        }
        class_7771 dimensions = ((TextureData)data.get((Object)ConnectedShape.ALL)).getDimensions();
        int width = dimensions.comp_1049();
        int height = dimensions.comp_1050();
        int halfWidth = width / 2;
        int halfHeight = height / 2;
        for (ConnectedPattern pattern : ConnectedPattern.values()) {
            if (pattern.allMatch()) continue;
            TextureData nw = (TextureData)data.get((Object)pattern.getNW());
            TextureData ne = (TextureData)data.get((Object)pattern.getNE());
            TextureData se = (TextureData)data.get((Object)pattern.getSE());
            TextureData sw = (TextureData)data.get((Object)pattern.getSW());
            class_2960 texture = pattern.addSuffix(this.getBaseName());
            regions.method_47670(texture, spriteOpener -> {
                class_1011 nativeImage = AtlasSourceUtil.createNativeImage(width, height, (index, x, y, u, v) -> (x >= halfWidth ? (y >= halfHeight ? se : ne) : (y >= halfHeight ? sw : nw)).data()[index]);
                return new class_7764(texture, dimensions, nativeImage);
            });
        }
    }
}

