/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.common.text;

import com.eightsidedsquare.zine.common.text.CustomStyleAttribute;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public sealed interface CustomStyleAttributeContainer {
    public static final Codec<Map<CustomStyleAttribute<?>, Object>> ATTRIBUTE_TO_VALUE_MAP_CODEC = Codec.dispatchedMap(CustomStyleAttribute.CODEC, CustomStyleAttribute::getCodec);
    public static final Codec<CustomStyleAttributeContainer> CODEC = ATTRIBUTE_TO_VALUE_MAP_CODEC.xmap(map -> switch (map.size()) {
        case 0 -> Empty.INSTANCE;
        case 1 -> Single.ofEntry(map.entrySet().iterator().next());
        default -> new MapBacked((Reference2ObjectMap<CustomStyleAttribute<?>, Object>)new Reference2ObjectArrayMap(map));
    }, container -> {
        CustomStyleAttributeContainer customStyleAttributeContainer = container;
        Objects.requireNonNull(customStyleAttributeContainer);
        CustomStyleAttributeContainer selector0$temp = customStyleAttributeContainer;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Single.class, MapBacked.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                Single single = (Single)selector0$temp;
                yield Map.of(single.attribute, single.value);
            }
            case 1 -> {
                MapBacked mapBacked = (MapBacked)selector0$temp;
                yield mapBacked.attributes;
            }
            default -> Map.of();
        };
    });

    public static CustomStyleAttributeContainer create() {
        return Empty.INSTANCE;
    }

    @Nullable
    public <T> T get(CustomStyleAttribute<T> var1);

    default public <T> T getOrDefault(CustomStyleAttribute<T> attribute, T defaultValue) {
        T value = this.get(attribute);
        return value == null ? defaultValue : value;
    }

    public boolean contains(CustomStyleAttribute<?> var1);

    public <T> CustomStyleAttributeContainer with(CustomStyleAttribute<T> var1, T var2);

    public CustomStyleAttributeContainer with(CustomStyleAttributeContainer var1);

    public boolean isEmpty();

    public int size();

    public static final class Empty
    implements CustomStyleAttributeContainer {
        public static final Empty INSTANCE = new Empty();

        Empty() {
        }

        @Override
        @Nullable
        public <T> T get(CustomStyleAttribute<T> attribute) {
            return null;
        }

        @Override
        public boolean contains(CustomStyleAttribute<?> attribute) {
            return false;
        }

        @Override
        public <T> CustomStyleAttributeContainer with(CustomStyleAttribute<T> attribute, T value) {
            return new Single<T>(attribute, value);
        }

        @Override
        public CustomStyleAttributeContainer with(CustomStyleAttributeContainer container) {
            return container;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }

        public String toString() {
            return "{}";
        }
    }

    public static final class Single<V>
    implements CustomStyleAttributeContainer {
        private final CustomStyleAttribute<V> attribute;
        private final V value;

        Single(CustomStyleAttribute<V> attribute, V value) {
            this.attribute = attribute;
            this.value = value;
        }

        static Single<?> ofEntry(Map.Entry<CustomStyleAttribute<?>, ?> entry) {
            return Single.unchecked(entry.getKey(), entry.getValue());
        }

        static <V> Single<V> unchecked(CustomStyleAttribute<V> attribute, Object value) {
            return new Single<Object>(attribute, value);
        }

        @Override
        @Nullable
        public <T> T get(CustomStyleAttribute<T> attribute) {
            return attribute == this.attribute ? (T)this.value : null;
        }

        @Override
        public boolean contains(CustomStyleAttribute<?> attribute) {
            return this.attribute == attribute;
        }

        @Override
        public <T> CustomStyleAttributeContainer with(CustomStyleAttribute<T> attribute, T value) {
            if (attribute == this.attribute) {
                return value == this.value ? this : new Single<T>(attribute, value);
            }
            Reference2ObjectArrayMap attributes = new Reference2ObjectArrayMap();
            attributes.put(this.attribute, this.value);
            attributes.put(attribute, value);
            return new MapBacked((Reference2ObjectMap<CustomStyleAttribute<?>, Object>)attributes);
        }

        @Override
        public CustomStyleAttributeContainer with(CustomStyleAttributeContainer container) {
            CustomStyleAttributeContainer customStyleAttributeContainer = container;
            Objects.requireNonNull(customStyleAttributeContainer);
            CustomStyleAttributeContainer customStyleAttributeContainer2 = customStyleAttributeContainer;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MapBacked.class, Single.class}, (Object)customStyleAttributeContainer2, n)) {
                case 0 -> {
                    MapBacked mapBacked = (MapBacked)customStyleAttributeContainer2;
                    yield mapBacked.with(this.attribute, this.value);
                }
                case 1 -> {
                    Single single = (Single)customStyleAttributeContainer2;
                    yield single.with(this.attribute, this.value);
                }
                default -> this;
            };
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public int size() {
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Single)) {
                return false;
            }
            Single single = (Single)o;
            return Objects.equals(this.attribute, single.attribute) && Objects.equals(this.value, single.value);
        }

        public int hashCode() {
            return Objects.hash(this.attribute, this.value);
        }

        public String toString() {
            return "{" + String.valueOf(this.attribute) + "=>" + String.valueOf(this.value) + "}";
        }
    }

    public static final class MapBacked
    implements CustomStyleAttributeContainer {
        private final Reference2ObjectMap<CustomStyleAttribute<?>, Object> attributes;

        MapBacked(Reference2ObjectMap<CustomStyleAttribute<?>, Object> attributes) {
            this.attributes = attributes;
        }

        @Override
        @Nullable
        public <T> T get(CustomStyleAttribute<T> attribute) {
            Object value = this.attributes.get(attribute);
            return (T)(value == null ? null : value);
        }

        @Override
        public boolean contains(CustomStyleAttribute<?> attribute) {
            return this.attributes.containsKey(attribute);
        }

        @Override
        public <T> CustomStyleAttributeContainer with(CustomStyleAttribute<T> attribute, T value) {
            Reference2ObjectArrayMap attributes = new Reference2ObjectArrayMap(this.attributes);
            attributes.put(attribute, value);
            return new MapBacked((Reference2ObjectMap<CustomStyleAttribute<?>, Object>)attributes);
        }

        @Override
        public CustomStyleAttributeContainer with(CustomStyleAttributeContainer container) {
            CustomStyleAttributeContainer customStyleAttributeContainer = container;
            Objects.requireNonNull(customStyleAttributeContainer);
            CustomStyleAttributeContainer customStyleAttributeContainer2 = customStyleAttributeContainer;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MapBacked.class, Single.class}, (Object)customStyleAttributeContainer2, n)) {
                case 0 -> {
                    MapBacked mapBacked = (MapBacked)customStyleAttributeContainer2;
                    Reference2ObjectArrayMap attributes = new Reference2ObjectArrayMap(this.attributes);
                    attributes.putAll(mapBacked.attributes);
                    yield new MapBacked((Reference2ObjectMap<CustomStyleAttribute<?>, Object>)attributes);
                }
                case 1 -> {
                    Single single = (Single)customStyleAttributeContainer2;
                    yield this.with(single);
                }
                default -> this;
            };
        }

        @Override
        public boolean isEmpty() {
            return this.attributes.isEmpty();
        }

        @Override
        public int size() {
            return this.attributes.size();
        }

        public boolean equals(Object o) {
            if (!(o instanceof MapBacked)) {
                return false;
            }
            MapBacked mapBacked = (MapBacked)o;
            return Objects.equals(this.attributes, mapBacked.attributes);
        }

        public int hashCode() {
            return Objects.hashCode(this.attributes);
        }

        public String toString() {
            return this.attributes.toString();
        }
    }
}

