/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.common.util.codec;

import com.eightsidedsquare.zine.common.entity.SpawnReasonIds;
import com.eightsidedsquare.zine.common.util.codec.AlternativeCodec;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2379;
import net.minecraft.class_238;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3730;
import net.minecraft.class_5251;
import net.minecraft.class_5699;
import net.minecraft.class_7923;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableByte;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.mutable.MutableShort;

public final class CodecUtil {
    public static final Codec<Character> CHARACTER = Codec.string((int)1, (int)1).xmap(string -> Character.valueOf(string.charAt(0)), String::valueOf);
    public static final Codec<class_2379> EULER_ANGLE = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.optionalFieldOf("pitch", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3776), (App)Codec.FLOAT.optionalFieldOf("yaw", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3777), (App)Codec.FLOAT.optionalFieldOf("roll", (Object)Float.valueOf(0.0f)).forGetter(class_2379::comp_3778)).apply((Applicative)instance, class_2379::new));
    public static final Codec<Integer> INT_STRING = Codec.STRING.comapFlatMap(string -> {
        int value;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return DataResult.error(() -> "Failed to parse int from " + string);
        }
        return DataResult.success((Object)value);
    }, String::valueOf);
    public static final Codec<class_2248> BLOCK = class_7923.field_41175.method_39673();
    public static final Codec<Integer> COLOR = AlternativeCodec.create(class_5699.field_54067, class_5251.field_39242, color -> Optional.of(class_5251.method_27717((int)color)), textColor -> textColor.method_27716() | 0xFF000000);
    public static final Codec<class_3730> SPAWN_REASON = SpawnReasonIds.IDS.method_65323(class_2960.field_25139);
    public static final Codec<class_238> CODEC = Codec.DOUBLE.listOf().comapFlatMap(vertices -> class_156.method_33141((List)vertices, (int)6).map(list -> new class_238(((Double)list.getFirst()).doubleValue(), ((Double)list.get(1)).doubleValue(), ((Double)list.get(2)).doubleValue(), ((Double)list.get(3)).doubleValue(), ((Double)list.get(4)).doubleValue(), ((Double)list.get(5)).doubleValue())), box -> List.of(Double.valueOf(box.field_1323), Double.valueOf(box.field_1322), Double.valueOf(box.field_1321), Double.valueOf(box.field_1320), Double.valueOf(box.field_1325), Double.valueOf(box.field_1324)));
    public static final Codec<MutableBoolean> MUTABLE_BOOLEAN = Codec.BOOL.xmap(MutableBoolean::new, MutableBoolean::booleanValue);
    public static final Codec<MutableByte> MUTABLE_BYTE = Codec.BYTE.xmap(MutableByte::new, MutableByte::byteValue);
    public static final Codec<MutableShort> MUTABLE_SHORT = Codec.SHORT.xmap(MutableShort::new, MutableShort::shortValue);
    public static final Codec<MutableInt> MUTABLE_INT = Codec.INT.xmap(MutableInt::new, MutableInt::intValue);
    public static final Codec<MutableLong> MUTABLE_LONG = Codec.LONG.xmap(MutableLong::new, MutableLong::longValue);
    public static final Codec<MutableFloat> MUTABLE_FLOAT = Codec.FLOAT.xmap(MutableFloat::new, MutableFloat::floatValue);
    public static final Codec<MutableDouble> MUTABLE_DOUBLE = Codec.DOUBLE.xmap(MutableDouble::new, MutableDouble::doubleValue);

    public static <A> Codec<List<A>> listCodec(Codec<A> codec) {
        return Codec.either(codec, (Codec)codec.listOf()).xmap(either -> (List)either.map(List::of, list -> list), list -> list.size() == 1 ? Either.left(list.getFirst()) : Either.right((Object)list));
    }

    public static <A> Codec<List<A>> nonEmptyListCodec(Codec<A> codec) {
        return CodecUtil.listCodec(codec).validate(list -> list.isEmpty() ? DataResult.error(() -> "Empty list") : DataResult.success((Object)list));
    }

    public static <O, T> Codec<O> codec(RecordCodecBuilder<O, T> field, Function<T, O> function) {
        return RecordCodecBuilder.create(instance -> instance.group((App)field).apply((Applicative)instance, function));
    }

    public static <O, T> MapCodec<O> mapCodec(RecordCodecBuilder<O, T> field, Function<T, O> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)field).apply((Applicative)instance, function));
    }

    public static Codec<class_2248> blockCodecWithProperties(class_2769<?> ... properties) {
        return BLOCK.validate(block -> {
            Collection blockProperties = block.method_9595().method_11659();
            for (class_2769 property : properties) {
                if (blockProperties.contains(property)) continue;
                return DataResult.error(() -> String.valueOf(block) + " does not contain property " + String.valueOf(property));
            }
            return DataResult.success((Object)block);
        });
    }

    public static Codec<class_2248> blockCodecWithPropertiesOf(class_2248 block) {
        return CodecUtil.blockCodecWithProperties(block.method_9595().method_11659().toArray(new class_2769[0]));
    }

    public static <T> void readToList(class_11368 view, String key, List<T> list, Codec<? extends Collection<? extends T>> codec) {
        list.clear();
        view.method_71426(key, codec).ifPresent(list::addAll);
    }

    public static <K, V> void readToMap(class_11368 view, String key, Map<K, V> map, Codec<? extends Map<? extends K, ? extends V>> codec) {
        map.clear();
        view.method_71426(key, codec).ifPresent(map::putAll);
    }

    public static <T> Codec<MutableObject<T>> mutable(Codec<T> codec) {
        return codec.xmap(MutableObject::new, MutableObject::getValue);
    }

    private CodecUtil() {
    }
}

