/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.common.util.network;

import com.google.common.collect.ImmutableList;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_10941;
import net.minecraft.class_2248;
import net.minecraft.class_2361;
import net.minecraft.class_238;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_3341;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9336;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableByte;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.mutable.MutableShort;
import org.jetbrains.annotations.Nullable;

public final class PacketCodecUtil {
    public static final class_9139<class_2540, class_2680> BLOCK_STATE = PacketCodecUtil.state(class_2248.field_10651, class_2248::method_9507);
    public static final class_9139<class_2540, class_3610> FLUID_STATE = PacketCodecUtil.state(class_3611.field_15904);
    public static final class_9139<class_9129, class_9323> COMPONENT_MAP = class_9336.field_49657.method_56433(class_9135.method_56363()).method_56432(components -> {
        class_9323.class_9324 builder = class_9323.method_57827();
        components.forEach(arg_0 -> builder.zine$add(arg_0));
        return builder.method_57838();
    }, componentMap -> ImmutableList.copyOf((Iterator)componentMap.iterator()));
    public static final class_9139<ByteBuf, class_238> BOX = class_9139.method_58025((class_9139)class_9135.field_48553, box -> box.field_1323, (class_9139)class_9135.field_48553, box -> box.field_1322, (class_9139)class_9135.field_48553, box -> box.field_1321, (class_9139)class_9135.field_48553, box -> box.field_1320, (class_9139)class_9135.field_48553, box -> box.field_1325, (class_9139)class_9135.field_48553, box -> box.field_1324, class_238::new);
    public static final class_9139<ByteBuf, class_3341> BLOCK_BOX = class_9139.method_58025((class_9139)class_9135.field_48550, class_3341::method_35415, (class_9139)class_9135.field_48550, class_3341::method_35416, (class_9139)class_9135.field_48550, class_3341::method_35417, (class_9139)class_9135.field_48550, class_3341::method_35418, (class_9139)class_9135.field_48550, class_3341::method_35419, (class_9139)class_9135.field_48550, class_3341::method_35420, class_3341::new);
    public static final class_9139<ByteBuf, MutableBoolean> MUTABLE_BOOLEAN = class_9135.field_48547.method_56432(MutableBoolean::new, MutableBoolean::booleanValue);
    public static final class_9139<ByteBuf, MutableByte> MUTABLE_BYTE = class_9135.field_48548.method_56432(MutableByte::new, MutableByte::byteValue);
    public static final class_9139<ByteBuf, MutableShort> MUTABLE_SHORT = class_9135.field_48549.method_56432(MutableShort::new, MutableShort::shortValue);
    public static final class_9139<ByteBuf, MutableInt> MUTABLE_INT = class_9135.field_49675.method_56432(MutableInt::new, MutableInt::intValue);
    public static final class_9139<ByteBuf, MutableInt> MUTABLE_VAR_INT = class_9135.field_48550.method_56432(MutableInt::new, MutableInt::intValue);
    public static final class_9139<ByteBuf, MutableLong> MUTABLE_LONG = class_9135.field_54505.method_56432(MutableLong::new, MutableLong::longValue);
    public static final class_9139<ByteBuf, MutableLong> MUTABLE_VAR_LONG = class_9135.field_48551.method_56432(MutableLong::new, MutableLong::longValue);
    public static final class_9139<ByteBuf, MutableFloat> MUTABLE_FLOAT = class_9135.field_48552.method_56432(MutableFloat::new, MutableFloat::floatValue);
    public static final class_9139<ByteBuf, MutableDouble> MUTABLE_DOUBLE = class_9135.field_48553.method_56432(MutableDouble::new, MutableDouble::doubleValue);

    public static <B, V> class_9139<B, MutableObject<V>> mutable(class_9139<B, V> packetCodec) {
        return packetCodec.method_56432(MutableObject::new, MutableObject::getValue);
    }

    public static <T extends class_2688<?, ?>> class_9139<class_2540, T> state(class_2361<T> idList, @Nullable Function<T, Integer> idGetter) {
        Function<Object, Integer> finalIdGetter = idGetter != null ? idGetter : state -> {
            int id = idList.method_10206(state);
            return id == -1 ? 0 : id;
        };
        return class_9139.method_56438((state, buf) -> buf.method_10804(((Integer)finalIdGetter.apply(state)).intValue()), buf -> {
            int id = buf.method_10816();
            class_2688 state = (class_2688)idList.method_10200(id);
            if (state == null) {
                throw new class_10941("Unknown state with id " + id);
            }
            return state;
        });
    }

    public static <T extends class_2688<?, ?>> class_9139<class_2540, T> state(class_2361<T> idList) {
        return PacketCodecUtil.state(idList, null);
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> class_9139<B, M> dispatchedMap(final IntFunction<? extends M> factory, final class_9139<? super B, K> keyCodec, final Function<K, class_9139<? super B, V>> valueCodecFunction, final int maxSize) {
        return new class_9139<B, M>(){

            public void encode(B buf, M map) {
                class_9135.method_57990(buf, (int)map.size(), (int)maxSize);
                map.forEach((k, v) -> {
                    keyCodec.encode(buf, k);
                    ((class_9139)valueCodecFunction.apply(k)).encode(buf, v);
                });
            }

            public M decode(B buf) {
                int size = class_9135.method_57989(buf, (int)maxSize);
                Map map = (Map)factory.apply(Math.min(size, 65536));
                for (int i = 0; i < size; ++i) {
                    Object key = keyCodec.decode(buf);
                    map.put(key, ((class_9139)valueCodecFunction.apply(key)).decode(buf));
                }
                return map;
            }
        };
    }

    public static <B extends ByteBuf, K, V, M extends Map<K, V>> class_9139<B, M> dispatchedMap(IntFunction<? extends M> factory, class_9139<? super B, K> keyCodec, Function<K, class_9139<? super B, V>> valueCodecFunction) {
        return PacketCodecUtil.dispatchedMap(factory, keyCodec, valueCodecFunction, Integer.MAX_VALUE);
    }

    private PacketCodecUtil() {
    }
}

