/*
 * Decompiled with CFR 0.152.
 */
package com.eightsidedsquare.zine.data.sound;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_3542;
import net.minecraft.class_5699;

public class SoundBuilder {
    private static final Codec<SoundBuilder> SOUND_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(soundBuilder -> soundBuilder.name), (App)class_5699.field_34387.optionalFieldOf("volume", (Object)Float.valueOf(1.0f)).forGetter(soundBuilder -> Float.valueOf(soundBuilder.volume)), (App)class_5699.field_34387.optionalFieldOf("pitch", (Object)Float.valueOf(1.0f)).forGetter(soundBuilder -> Float.valueOf(soundBuilder.pitch)), (App)class_5699.field_33442.optionalFieldOf("weight", (Object)1).forGetter(soundBuilder -> soundBuilder.weight), (App)Type.CODEC.optionalFieldOf("type", (Object)Type.FILE).forGetter(soundBuilder -> soundBuilder.type), (App)Codec.BOOL.optionalFieldOf("stream", (Object)false).forGetter(soundBuilder -> soundBuilder.stream), (App)Codec.BOOL.optionalFieldOf("preload", (Object)false).forGetter(soundBuilder -> soundBuilder.preload), (App)Codec.INT.optionalFieldOf("attenuation_distance", (Object)16).forGetter(soundBuilder -> soundBuilder.attenuation)).apply((Applicative)instance, SoundBuilder::new));
    static final Codec<SoundBuilder> CODEC = Codec.either((Codec)Codec.STRING, SOUND_CODEC).xmap(either -> (SoundBuilder)either.map(SoundBuilder::of, sound -> sound), sound -> sound.isDefaultSound() ? Either.left((Object)sound.name) : Either.right((Object)sound));
    private final String name;
    private final Type type;
    private float volume = 1.0f;
    private float pitch = 1.0f;
    private int weight = 1;
    private boolean stream = false;
    private boolean preload = false;
    private int attenuation = 16;

    private SoundBuilder(String name, Type type) {
        this.type = type;
        this.name = this.type == Type.FILE ? name.replaceAll("\\.", "/") : name;
    }

    private SoundBuilder(String name, float volume, float pitch, int weight, Type type, boolean stream, boolean preload, int attenuation) {
        this(name, type);
        this.volume = volume;
        this.pitch = pitch;
        this.weight = weight;
        this.stream = stream;
        this.preload = preload;
        this.attenuation = attenuation;
    }

    public static SoundBuilder of(String name, Type type) {
        return new SoundBuilder(name, type);
    }

    public static SoundBuilder of(String name) {
        return SoundBuilder.of(name, Type.FILE);
    }

    public SoundBuilder volume(float volume) {
        this.volume = Math.max(Float.MIN_VALUE, volume);
        return this;
    }

    public SoundBuilder pitch(float pitch) {
        this.pitch = Math.max(Float.MIN_VALUE, pitch);
        return this;
    }

    public SoundBuilder weight(int weight) {
        this.weight = Math.max(1, weight);
        return this;
    }

    public SoundBuilder stream(boolean stream) {
        this.stream = stream;
        return this;
    }

    public SoundBuilder preload(boolean preload) {
        this.preload = preload;
        return this;
    }

    public SoundBuilder attenuation(int attenuation) {
        this.attenuation = attenuation;
        return this;
    }

    private boolean isDefaultSound() {
        return this.volume == 1.0f && this.pitch == 1.0f && this.weight == 1 && this.type == Type.FILE && !this.stream && !this.preload && this.attenuation == 16;
    }

    public static enum Type implements class_3542
    {
        FILE("file"),
        SOUND_EVENT("event");

        public static final Codec<Type> CODEC;
        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }
}

