/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.mining_quakes.particle;

import com.gaura.mining_quakes.MiningQuakes;
import com.gaura.mining_quakes.mixin.ClientLevelAccessor;
import com.gaura.mining_quakes.mixin.LevelRendererAccessor;
import com.gaura.mining_quakes.particle.BlockQuakeParticleManager;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Map;
import java.util.SortedSet;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2244;
import net.minecraft.class_2281;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2745;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3191;
import net.minecraft.class_3532;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4583;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_778;
import net.minecraft.class_7833;
import org.jetbrains.annotations.NotNull;

public class BlockQuakeParticle
extends class_703 {
    private final class_2338 blockPos;
    private final class_2680 blockState;
    private final class_2350 direction;
    private final class_778 modelBlockRenderer;
    private final class_1087 bakedModel;
    private final class_5819 source;
    private class_243 pivotPoint;
    private final int randomHorizontal;
    private final int randomVertical;
    static final Map<class_2350, RotationPair> ROTATIONS = Map.of(class_2350.field_11035, new RotationPair(class_7833.field_40718, class_7833.field_40716), class_2350.field_11043, new RotationPair(class_7833.field_40717, class_7833.field_40716), class_2350.field_11034, new RotationPair(class_7833.field_40714, class_7833.field_40716), class_2350.field_11039, new RotationPair(class_7833.field_40713, class_7833.field_40716), class_2350.field_11033, new RotationPair(class_7833.field_40714, class_7833.field_40718), class_2350.field_11036, new RotationPair(class_7833.field_40713, class_7833.field_40718));

    public BlockQuakeParticle(class_638 clientLevel, class_2338 blockPos, class_2680 blockState, class_2350 direction, int randomHorizontal, int randomVertical) {
        super(clientLevel, (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260());
        this.field_3866 = 0;
        this.field_3847 = MiningQuakes.CONFIG.lifetime;
        this.field_3862 = false;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.direction = direction;
        this.modelBlockRenderer = class_310.method_1551().method_1541().method_3350();
        this.bakedModel = class_310.method_1551().method_1541().method_3349(blockState);
        this.source = class_5819.method_43047();
        this.pivotPoint = new class_243(0.5, 0.5, 0.5);
        if (blockState.method_26204() instanceof class_2323) {
            this.pivotPoint = this.pivotPoint.method_43206(((class_2756)blockState.method_11654((class_2769)class_2323.field_10946)).method_54779(), 0.5);
        } else if (blockState.method_26204() instanceof class_2281 && blockState.method_11654((class_2769)class_2281.field_10770) != class_2745.field_12569) {
            this.pivotPoint = this.pivotPoint.method_43206(class_2281.method_9758((class_2680)blockState), 0.5);
        } else if (blockState.method_26204() instanceof class_2244) {
            this.pivotPoint = this.pivotPoint.method_43206(class_2244.method_24163((class_2680)blockState), 0.5);
        }
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
    }

    public void method_3070() {
        this.field_3858 = this.field_3874;
        this.field_3838 = this.field_3854;
        this.field_3856 = this.field_3871;
        ++this.field_3866;
        if (this.field_3866 == this.field_3847) {
            BlockQuakeParticleManager.setBlockVisible(this.field_3851, this.blockPos, this.blockState);
        } else if (this.field_3866 > this.field_3847) {
            this.method_3085();
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float f) {
        class_4587 poseStack = new class_4587();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        float x = (float)(class_3532.method_16436((double)f, (double)this.field_3858, (double)this.field_3874) - camera.method_19326().method_10216());
        float y = (float)(class_3532.method_16436((double)f, (double)this.field_3838, (double)this.field_3854) - camera.method_19326().method_10214());
        float z = (float)(class_3532.method_16436((double)f, (double)this.field_3856, (double)this.field_3871) - camera.method_19326().method_10215());
        poseStack.method_46416(x, y, z);
        this.animate(poseStack, f);
        this.modelBlockRenderer.method_3374((class_1920)this.field_3851, this.bakedModel, this.blockState, this.blockPos, poseStack, bufferSource.getBuffer(MiningQuakes.isContinuityLoaded() ? class_1921.method_23581() : class_4696.method_29359((class_2680)this.blockState)), false, this.source, this.blockState.method_26190(this.blockPos), class_4608.field_21444);
        Long2ObjectMap<SortedSet<class_3191>> destructionProgress = ((LevelRendererAccessor)((ClientLevelAccessor)this.field_3851).getLevelRenderer()).getDestructionProgress();
        SortedSet progressSet = (SortedSet)destructionProgress.get(this.blockPos.method_10063());
        if (progressSet != null && !progressSet.isEmpty()) {
            this.modelBlockRenderer.method_3374((class_1920)this.field_3851, this.bakedModel, this.blockState, this.blockPos, poseStack, (class_4588)new class_4583(bufferSource.getBuffer((class_1921)class_1088.field_21772.get(((class_3191)progressSet.last()).method_13988())), poseStack.method_23760(), 1.0f), true, this.source, this.blockState.method_26190(this.blockPos), class_4608.field_21444);
        }
        bufferSource.method_22993();
    }

    public void animate(class_4587 poseStack, float f) {
        float t = ((float)this.field_3866 + f) / (float)this.field_3847;
        float horizontalOscillations = (float)Math.sin((double)MiningQuakes.CONFIG.horizontalOscillations * Math.PI * (double)t);
        float verticalOscillations = (float)Math.sin((double)MiningQuakes.CONFIG.verticalOscillations * Math.PI * (double)t);
        float decay = MiningQuakes.CONFIG.easingFunction.apply(t);
        float horizontalAngle = MiningQuakes.CONFIG.horizontalMaxAngle * horizontalOscillations * decay;
        float verticalAngle = MiningQuakes.CONFIG.verticalMaxAngle * verticalOscillations * decay;
        if (MiningQuakes.CONFIG.randomQuakes) {
            horizontalAngle *= (float)this.randomHorizontal;
            verticalAngle *= (float)this.randomVertical;
        }
        RotationPair rotation = ROTATIONS.get(this.direction);
        poseStack.method_22904(this.pivotPoint.field_1352, this.pivotPoint.field_1351, this.pivotPoint.field_1350);
        poseStack.method_22907(rotation.horizontalAxis.rotationDegrees(verticalAngle));
        poseStack.method_22907(rotation.verticalAxis.rotationDegrees(horizontalAngle));
        poseStack.method_22904(-this.pivotPoint.field_1352, -this.pivotPoint.field_1351, -this.pivotPoint.field_1350);
    }

    @NotNull
    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    record RotationPair(class_7833 horizontalAxis, class_7833 verticalAxis) {
    }
}

