/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.mining_quakes.mixin;

import com.gaura.mining_quakes.MiningQuakes;
import com.gaura.mining_quakes.particle.BlockQuakeParticleManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MultiPlayerGameMode.class})
public class MultiPlayerGameModeMixin {
    @Shadow
    @Final
    private Minecraft f_105189_;

    @Inject(method={"destroyBlock"}, at={@At(value="HEAD")})
    private void onDestroyBlock(BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        ClientLevel clientLevel = this.f_105189_.f_91073_;
        if (clientLevel != null && BlockQuakeParticleManager.isBlockInvisible(blockPos)) {
            BlockState blockState = clientLevel.m_8055_(blockPos);
            BlockQuakeParticleManager.removeQuakeAnimation(clientLevel, blockPos, blockState);
            if (blockState.m_60734_() instanceof DoorBlock) {
                Direction doorPart = blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
                BlockPos otherBlockPos = blockPos.m_121945_(doorPart);
                BlockState otherBlockState = clientLevel.m_8055_(otherBlockPos);
                BlockQuakeParticleManager.removeQuakeAnimation(clientLevel, otherBlockPos, otherBlockState);
            } else if (blockState.m_60734_() instanceof ChestBlock && blockState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                BlockPos otherBlockPos = blockPos.m_121945_(ChestBlock.m_51584_((BlockState)blockState));
                BlockState otherBlockState = clientLevel.m_8055_(otherBlockPos);
                BlockQuakeParticleManager.removeQuakeAnimation(clientLevel, otherBlockPos, otherBlockState);
            } else if (blockState.m_60734_() instanceof BedBlock) {
                BlockPos otherBlockPos = blockPos.m_121945_(BedBlock.m_49557_((BlockState)blockState));
                BlockState otherBlockState = clientLevel.m_8055_(otherBlockPos);
                BlockQuakeParticleManager.removeQuakeAnimation(clientLevel, otherBlockPos, otherBlockState);
            }
        }
    }

    @Inject(method={"continueDestroyBlock"}, at={@At(value="HEAD")})
    private void onContinueDestroyBlock(BlockPos blockPos, Direction direction, CallbackInfoReturnable<Boolean> cir) {
        ClientLevel clientLevel = this.f_105189_.f_91073_;
        if (clientLevel != null) {
            BlockState blockState = clientLevel.m_8055_(blockPos);
            if (!BlockQuakeParticleManager.isBlockInvisible(blockPos) && !MiningQuakes.isBlockBlacklisted(blockState)) {
                int randomHorizontal = RandomSource.m_216327_().m_188499_() ? 1 : -1;
                int randomVertical = RandomSource.m_216327_().m_188499_() ? 1 : -1;
                BlockQuakeParticleManager.addQuakeAnimation(clientLevel, blockPos.m_7949_(), blockState, direction, randomHorizontal, randomVertical);
                if (blockState.m_60734_() instanceof DoorBlock) {
                    Direction doorPart = blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
                    BlockPos otherBlockPos = blockPos.m_121945_(doorPart);
                    BlockState otherBlockState = clientLevel.m_8055_(otherBlockPos);
                    BlockQuakeParticleManager.addQuakeAnimation(clientLevel, otherBlockPos.m_7949_(), otherBlockState, direction, randomHorizontal, randomVertical);
                } else if (blockState.m_60734_() instanceof ChestBlock && blockState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
                    BlockPos otherBlockPos = blockPos.m_121945_(ChestBlock.m_51584_((BlockState)blockState));
                    BlockState otherBlockState = clientLevel.m_8055_(otherBlockPos);
                    BlockQuakeParticleManager.addQuakeAnimation(clientLevel, otherBlockPos.m_7949_(), otherBlockState, direction, randomHorizontal, randomVertical);
                } else if (blockState.m_60734_() instanceof BedBlock) {
                    BlockPos otherBlockPos = blockPos.m_121945_(BedBlock.m_49557_((BlockState)blockState));
                    BlockState otherBlockState = clientLevel.m_8055_(otherBlockPos);
                    BlockQuakeParticleManager.addQuakeAnimation(clientLevel, otherBlockPos.m_7949_(), otherBlockState, direction, randomHorizontal, randomVertical);
                }
            }
        }
    }
}

