/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.mining_quakes.particle;

import com.gaura.mining_quakes.MiningQuakes;
import com.gaura.mining_quakes.mixin.ClientLevelAccessor;
import com.gaura.mining_quakes.mixin.LevelRendererAccessor;
import com.gaura.mining_quakes.particle.BlockQuakeParticleManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.Map;
import java.util.SortedSet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BlockQuakeParticle
extends Particle {
    private final BlockPos blockPos;
    private final BlockState blockState;
    private final Direction direction;
    private final ModelBlockRenderer modelBlockRenderer;
    private final BakedModel bakedModel;
    private final RandomSource source;
    private Vec3 pivotPoint;
    private final int randomHorizontal;
    private final int randomVertical;
    static final Map<Direction, RotationPair> ROTATIONS = Map.of(Direction.SOUTH, new RotationPair(Axis.f_252403_, Axis.f_252436_), Direction.NORTH, new RotationPair(Axis.f_252393_, Axis.f_252436_), Direction.EAST, new RotationPair(Axis.f_252529_, Axis.f_252436_), Direction.WEST, new RotationPair(Axis.f_252495_, Axis.f_252436_), Direction.DOWN, new RotationPair(Axis.f_252529_, Axis.f_252403_), Direction.UP, new RotationPair(Axis.f_252495_, Axis.f_252403_));

    public BlockQuakeParticle(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState, Direction direction, int randomHorizontal, int randomVertical) {
        super(clientLevel, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        this.f_107224_ = 0;
        this.f_107225_ = MiningQuakes.CONFIG.lifetime;
        this.f_107219_ = false;
        this.blockPos = blockPos;
        this.blockState = blockState;
        this.direction = direction;
        this.modelBlockRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
        this.bakedModel = Minecraft.m_91087_().m_91289_().m_110910_(blockState);
        this.source = RandomSource.m_216327_();
        this.pivotPoint = new Vec3(0.5, 0.5, 0.5);
        if (blockState.m_60734_() instanceof DoorBlock) {
            Direction doorPart = blockState.m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
            this.pivotPoint = this.pivotPoint.m_231075_(doorPart, 0.5);
        } else if (blockState.m_60734_() instanceof ChestBlock && blockState.m_61143_((Property)ChestBlock.f_51479_) != ChestType.SINGLE) {
            this.pivotPoint = this.pivotPoint.m_231075_(ChestBlock.m_51584_((BlockState)blockState), 0.5);
        } else if (blockState.m_60734_() instanceof BedBlock) {
            this.pivotPoint = this.pivotPoint.m_231075_(BedBlock.m_49557_((BlockState)blockState), 0.5);
        }
        this.randomHorizontal = randomHorizontal;
        this.randomVertical = randomVertical;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        ++this.f_107224_;
        if (this.f_107224_ == this.f_107225_) {
            BlockQuakeParticleManager.setBlockVisible(this.f_107208_, this.blockPos, this.blockState);
        } else if (this.f_107224_ > this.f_107225_) {
            this.m_107274_();
        }
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float f) {
        PoseStack poseStack = new PoseStack();
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        float x = (float)(Mth.m_14139_((double)f, (double)this.f_107209_, (double)this.f_107212_) - camera.m_90583_().m_7096_());
        float y = (float)(Mth.m_14139_((double)f, (double)this.f_107210_, (double)this.f_107213_) - camera.m_90583_().m_7098_());
        float z = (float)(Mth.m_14139_((double)f, (double)this.f_107211_, (double)this.f_107214_) - camera.m_90583_().m_7094_());
        poseStack.m_252880_(x, y, z);
        this.animate(poseStack, f);
        this.modelBlockRenderer.m_234379_((BlockAndTintGetter)this.f_107208_, this.bakedModel, this.blockState, this.blockPos, poseStack, bufferSource.m_6299_(MiningQuakes.isContinuityLoaded() ? RenderType.m_110463_() : ItemBlockRenderTypes.m_109293_((BlockState)this.blockState)), false, this.source, this.blockState.m_60726_(this.blockPos), OverlayTexture.f_118083_);
        Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = ((LevelRendererAccessor)((ClientLevelAccessor)this.f_107208_).getLevelRenderer()).getDestructionProgress();
        SortedSet progressSet = (SortedSet)destructionProgress.get(this.blockPos.m_121878_());
        if (progressSet != null && !progressSet.isEmpty()) {
            PoseStack.Pose pose = poseStack.m_85850_();
            this.modelBlockRenderer.m_234379_((BlockAndTintGetter)this.f_107208_, this.bakedModel, this.blockState, this.blockPos, poseStack, (VertexConsumer)new SheetedDecalTextureGenerator(bufferSource.m_6299_((RenderType)ModelBakery.f_119229_.get(((BlockDestructionProgress)progressSet.last()).m_139988_())), pose.m_252922_(), pose.m_252943_(), 1.0f), true, this.source, this.blockState.m_60726_(this.blockPos), OverlayTexture.f_118083_);
        }
        bufferSource.m_109911_();
    }

    public void animate(PoseStack poseStack, float f) {
        float t = ((float)this.f_107224_ + f) / (float)this.f_107225_;
        float horizontalOscillations = (float)Math.sin((double)MiningQuakes.CONFIG.horizontalOscillations * Math.PI * (double)t);
        float verticalOscillations = (float)Math.sin((double)MiningQuakes.CONFIG.verticalOscillations * Math.PI * (double)t);
        float decay = MiningQuakes.CONFIG.easingFunction.apply(t);
        float horizontalAngle = MiningQuakes.CONFIG.horizontalMaxAngle * horizontalOscillations * decay;
        float verticalAngle = MiningQuakes.CONFIG.verticalMaxAngle * verticalOscillations * decay;
        if (MiningQuakes.CONFIG.randomQuakes) {
            horizontalAngle *= (float)this.randomHorizontal;
            verticalAngle *= (float)this.randomVertical;
        }
        RotationPair rotation = ROTATIONS.get(this.direction);
        poseStack.m_85837_(this.pivotPoint.f_82479_, this.pivotPoint.f_82480_, this.pivotPoint.f_82481_);
        poseStack.m_252781_(rotation.horizontalAxis.m_252977_(verticalAngle));
        poseStack.m_252781_(rotation.verticalAxis.m_252977_(horizontalAngle));
        poseStack.m_85837_(-this.pivotPoint.f_82479_, -this.pivotPoint.f_82480_, -this.pivotPoint.f_82481_);
    }

    @NotNull
    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    record RotationPair(Axis horizontalAxis, Axis verticalAxis) {
    }
}

