/*
 * Decompiled with CFR 0.152.
 */
package com.gaura.mining_quakes.particle;

import com.gaura.mining_quakes.particle.BlockQuakeParticle;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;

public class BlockQuakeParticleManager {
    private static final Map<BlockPos, BlockQuakeParticle> BLOCK_QUAKE_PARTICLES = new HashMap<BlockPos, BlockQuakeParticle>();
    private static final Set<BlockPos> INVISIBLE_BLOCKS = new CopyOnWriteArraySet<BlockPos>();

    public static void addQuakeAnimation(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState, Direction direction, int randomHorizontal, int randomVertical) {
        BlockQuakeParticle blockQuakeParticle = new BlockQuakeParticle(clientLevel, blockPos, blockState, direction, randomHorizontal, randomVertical);
        BlockQuakeParticle previousBlockQuakeParticle = BLOCK_QUAKE_PARTICLES.put(blockPos, blockQuakeParticle);
        if (previousBlockQuakeParticle != null && previousBlockQuakeParticle.m_107276_()) {
            previousBlockQuakeParticle.m_107274_();
        }
        Minecraft.m_91087_().f_91061_.m_107344_((Particle)blockQuakeParticle);
        BlockQuakeParticleManager.setBlockInvisible(clientLevel, blockPos, blockState);
    }

    public static void addQuake(BlockPos blockPos, PoseStack poseStack, float f) {
        BlockQuakeParticle blockQuakeParticle = BLOCK_QUAKE_PARTICLES.get(blockPos);
        if (blockQuakeParticle != null && blockQuakeParticle.m_107276_()) {
            blockQuakeParticle.animate(poseStack, f);
        }
    }

    public static void removeQuakeAnimation(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState) {
        BlockQuakeParticle blockQuakeParticle = BLOCK_QUAKE_PARTICLES.remove(blockPos);
        if (blockQuakeParticle != null && blockQuakeParticle.m_107276_()) {
            blockQuakeParticle.m_107274_();
        }
        BlockQuakeParticleManager.setBlockVisible(clientLevel, blockPos, blockState);
    }

    public static void setBlockInvisible(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState) {
        if (INVISIBLE_BLOCKS.add(blockPos)) {
            BlockQuakeParticleManager.updateBlock(clientLevel, blockPos, blockState);
        }
    }

    public static void setBlockVisible(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState) {
        if (INVISIBLE_BLOCKS.remove(blockPos)) {
            BlockQuakeParticleManager.updateBlock(clientLevel, blockPos, blockState);
        }
    }

    public static boolean isBlockInvisible(BlockPos blockPos) {
        return INVISIBLE_BLOCKS.contains(blockPos);
    }

    private static void updateBlock(ClientLevel clientLevel, BlockPos blockPos, BlockState blockState) {
        clientLevel.m_7260_(blockPos, blockState, blockState, 2);
    }
}

