/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hm;

import dev.norska.hm.bukkit.Metrics;
import dev.norska.hm.commands.HitmarkerCommand;
import dev.norska.hm.commands.HitmarkerTabComplete;
import dev.norska.hm.listeners.HitmarkerHit;
import dev.norska.hm.listeners.HitmarkerToggleCommand;
import dev.norska.hm.listeners.JoinUpdateNotifier;
import dev.norska.hm.listeners.ProjectileTrailNewVer;
import dev.norska.hm.listeners.ProjectileTrailOldVer;
import dev.norska.hm.ndev.NorskaHandler;
import dev.norska.hm.ndev.NorskaUtils;
import dev.norska.hm.perms.HMPermHandler;
import dev.norska.niridiumcolorapi.IridiumColorAPI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Hitmarkers
extends JavaPlugin {
    private static Hitmarkers instance;
    private NorskaHandler nHandler = new NorskaHandler();
    private NorskaUtils nUtils = new NorskaUtils();
    private HMPermHandler permHandler = new HMPermHandler();
    public static List<UUID> toggled;
    public String prefix;

    public Hitmarkers() {
        instance = this;
    }

    public static Hitmarkers getInstance() {
        return instance;
    }

    public void onEnable() {
        this.generateFiles();
        this.cache();
        this.getNHandler().getMessageFeedbackHandler().loadConsoleMessages();
        this.checkUpdates();
        this.prefix = Bukkit.getVersion().contains("1.16") || Bukkit.getVersion().contains("1.17") || Bukkit.getVersion().contains("1.18") || Bukkit.getVersion().contains("1.19") || Bukkit.getVersion().contains("1.20") || Bukkit.getVersion().contains("1.21") ? IridiumColorAPI.process("&8[<GRADIENT:FF0000>Hitmarkers</GRADIENT:FFA2A2>&8]") : IridiumColorAPI.process("&8[&cHitmarkers&8]");
        this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("STARTUP", this.prefix, this.getDescription().getVersion());
        this.fetchAliases();
        this.registerEvents();
        this.registerCommands();
        this.checkHooks();
        this.loadCachedData();
        this.startMetricsService();
        this.getPermHandler().loadPerms();
        this.getNHandler().getMessageFeedbackHandler().loadTextComponents(this);
    }

    public void generateFiles() {
        this.getNHandler().getConfigurationHandler().generateFiles(instance);
    }

    public void cache() {
        this.getNHandler().getCacheHandler().cache(instance);
    }

    private void checkUpdates() {
        this.getNHandler().getUpdateHandler().fetchVersionFromServer(instance);
        this.getNHandler().getUpdateHandler().checkForUpdates(instance);
    }

    private void checkHooks() {
        this.getNHandler().getHooksHandler().checkForHooks(instance);
    }

    private void fetchAliases() {
        this.getNUtils().fetchAliases(instance);
    }

    private void startMetricsService() {
        Metrics metrics = new Metrics(this, 6043);
    }

    public void onDisable() {
        long nt = System.nanoTime();
        ArrayList converted = new ArrayList();
        toggled.forEach(entry -> converted.add(entry.toString()));
        this.getNHandler().getConfigurationHandler().getDataFile().set("data.save", converted);
        nt = System.nanoTime() - nt;
        int a = (int)TimeUnit.NANOSECONDS.toMillis(nt);
        try {
            this.getNHandler().getConfigurationHandler().getDataFile().save(new File(this.getDataFolder(), "data.yml"));
            this.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("SHUTDOWN_SAVE_SUCCESS", this.prefix, Integer.toString(a));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadCachedData() {
        if (this.getNHandler().getConfigurationHandler().getDataFile().isConfigurationSection("data")) {
            for (String entry : this.getNHandler().getConfigurationHandler().getDataFile().getStringList("data.save")) {
                toggled.add(UUID.fromString(entry));
            }
        }
    }

    private void registerEvents() {
        Bukkit.getPluginManager().registerEvents((Listener)new HitmarkerHit(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new HitmarkerToggleCommand(this), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new JoinUpdateNotifier(this), (Plugin)this);
        if (Bukkit.getVersion().contains("1.8")) {
            Bukkit.getPluginManager().registerEvents((Listener)new ProjectileTrailOldVer(this), (Plugin)this);
        } else {
            Bukkit.getPluginManager().registerEvents((Listener)new ProjectileTrailNewVer(this), (Plugin)this);
        }
    }

    private void registerCommands() {
        this.getCommand("hitmarkers").setExecutor((CommandExecutor)new HitmarkerCommand(this));
        this.getCommand("hitmarkers").setTabCompleter((TabCompleter)new HitmarkerTabComplete(this));
    }

    private boolean isFolia() {
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public NorskaHandler getNHandler() {
        return this.nHandler;
    }

    public NorskaUtils getNUtils() {
        return this.nUtils;
    }

    public HMPermHandler getPermHandler() {
        return this.permHandler;
    }

    static {
        toggled = new ArrayList<UUID>();
    }
}

