/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hm.reflection.constraint;

import dev.norska.hm.reflection.ReflectiveHandle;
import dev.norska.hm.reflection.XAccessFlag;
import dev.norska.hm.reflection.constraint.ReflectiveConstraint;
import java.lang.reflect.Member;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public enum VisibilityConstraint implements ReflectiveConstraint
{
    PUBLIC(XAccessFlag.PUBLIC),
    PRIVATE(XAccessFlag.PRIVATE),
    PROTECTED(XAccessFlag.PROTECTED);

    private final XAccessFlag accessFlag;

    private VisibilityConstraint(XAccessFlag accessFlag) {
        this.accessFlag = accessFlag;
    }

    @ApiStatus.Internal
    public XAccessFlag getAccessFlag() {
        return this.accessFlag;
    }

    @Override
    public ReflectiveConstraint.Result appliesTo(ReflectiveHandle<?> handle, Object jvm) {
        int mods;
        if (jvm instanceof Class) {
            mods = ((Class)jvm).getModifiers();
            if (this == PRIVATE) {
                return ReflectiveConstraint.Result.INCOMPATIBLE;
            }
            if (this == PROTECTED) {
                return ReflectiveConstraint.Result.of(!XAccessFlag.PUBLIC.isSet(mods));
            }
        } else if (jvm instanceof Member) {
            mods = ((Member)jvm).getModifiers();
        } else {
            return ReflectiveConstraint.Result.INCOMPATIBLE;
        }
        return ReflectiveConstraint.Result.of(this.accessFlag.isSet(mods));
    }

    @Override
    public String category() {
        return "Visibility";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "::" + this.name();
    }
}

