/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hm.ndev.handlers;

import dev.norska.hm.Hitmarkers;
import dev.norska.hm.ndev.handlers.NDebug;
import dev.norska.hm.ndev.objects.MessageObject;
import dev.norska.hm.ndev.objects.SoundObject;
import java.io.File;
import java.util.HashMap;
import java.util.List;

public class CacheHandler {
    private String editablePrefix;
    private Boolean mobsEnabled;
    private Boolean headshotsEnabled;
    private Boolean notifyForUpdates;
    private int particleAmount;
    private Double headshotDamage;
    private List<String> entityTypes;
    private List<String> disabledWorlds;
    private List<String> toggleCommands;
    private List<String> worldGuardWhitelist;
    private HashMap<String, MessageObject> messageMap = new HashMap();
    private HashMap<String, SoundObject> soundMap = new HashMap();
    private Boolean stripConsole;

    public void cache(Hitmarkers main) {
        this.cacheMessageFeedback(main);
        this.cacheSoundFeedback(main);
        this.stripConsole = main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("stripConsole");
        File debugEnabled = new File(main.getDataFolder(), "ndev.debug");
        NDebug.setEnabled(debugEnabled.exists());
        this.editablePrefix = main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages.prefix");
        this.notifyForUpdates = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("updates.notifications");
        this.mobsEnabled = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.mobs.enabled");
        this.entityTypes = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.mobs.entities");
        this.particleAmount = main.getNHandler().getConfigurationHandler().getConfigFile().getInt("settings.particles.amount");
        this.headshotsEnabled = main.getNHandler().getConfigurationHandler().getConfigFile().getBoolean("settings.headshots.enabled");
        this.headshotDamage = main.getNHandler().getConfigurationHandler().getConfigFile().getDouble("settings.headshots.extraDamage");
        this.disabledWorlds = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("settings.disabledWorlds");
        this.toggleCommands = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("toggleCommand.commands");
        this.worldGuardWhitelist = main.getNHandler().getConfigurationHandler().getConfigFile().getStringList("hooks.worldguard.whitelist");
    }

    private void cacheMessageFeedback(Hitmarkers main) {
        if (!this.messageMap.isEmpty()) {
            this.messageMap.clear();
        }
        for (String section : main.getNHandler().getConfigurationHandler().getMsgFile().getConfigurationSection("messages").getKeys(false)) {
            MessageObject message = new MessageObject();
            this.messageMap.put(section, message);
            message = this.messageMap.get(section);
            message.setChatMessageEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".chatMessage.enabled"));
            message.setChatMessageCentered(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".chatMessage.centered"));
            message.setChatMessageContent(main.getNHandler().getConfigurationHandler().getMsgFile().getStringList("messages." + section + ".chatMessage.content"));
            message.setActionbarEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".actionbar.enabled"));
            message.setActionbarContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".actionbar.content"));
            message.setActionbarDuration(main.getNHandler().getConfigurationHandler().getMsgFile().getInt("messages." + section + ".actionbar.duration"));
            message.setTitleEnabled(main.getNHandler().getConfigurationHandler().getMsgFile().getBoolean("messages." + section + ".titles.enabled"));
            message.setTitleContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".titles.titleContent"));
            message.setSubtitleContent(main.getNHandler().getConfigurationHandler().getMsgFile().getString("messages." + section + ".titles.subtitleContent"));
        }
    }

    private void cacheSoundFeedback(Hitmarkers main) {
        if (!this.soundMap.isEmpty()) {
            this.soundMap.clear();
        }
        for (String section : main.getNHandler().getConfigurationHandler().getSoundsFile().getConfigurationSection("sounds").getKeys(false)) {
            SoundObject sound = new SoundObject();
            this.soundMap.put(section, sound);
            sound = this.soundMap.get(section);
            sound.setEnabled(main.getNHandler().getConfigurationHandler().getSoundsFile().getBoolean("sounds." + section + ".enabled"));
            sound.setName(main.getNHandler().getConfigurationHandler().getSoundsFile().getString("sounds." + section + ".sound"));
            sound.setVolume((float)main.getNHandler().getConfigurationHandler().getSoundsFile().getDouble("sounds." + section + ".volume"));
            sound.setPitch((float)main.getNHandler().getConfigurationHandler().getSoundsFile().getDouble("sounds." + section + ".pitch"));
        }
    }

    public String getEditablePrefix() {
        return this.editablePrefix;
    }

    public Boolean getMobsEnabled() {
        return this.mobsEnabled;
    }

    public Boolean getHeadshotsEnabled() {
        return this.headshotsEnabled;
    }

    public Boolean getNotifyForUpdates() {
        return this.notifyForUpdates;
    }

    public int getParticleAmount() {
        return this.particleAmount;
    }

    public Double getHeadshotDamage() {
        return this.headshotDamage;
    }

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    public List<String> getDisabledWorlds() {
        return this.disabledWorlds;
    }

    public List<String> getToggleCommands() {
        return this.toggleCommands;
    }

    public List<String> getWorldGuardWhitelist() {
        return this.worldGuardWhitelist;
    }

    public HashMap<String, MessageObject> getMessageMap() {
        return this.messageMap;
    }

    public HashMap<String, SoundObject> getSoundMap() {
        return this.soundMap;
    }

    public Boolean getStripConsole() {
        return this.stripConsole;
    }
}

