/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hm.ndev.handlers;

import dev.norska.hm.Hitmarkers;
import dev.norska.niridiumcolorapi.IridiumColorAPI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class UpdateHandler {
    private Boolean updateAvailable = false;
    private String latestVersion;
    private String currentVersion;
    private int resourceID = 923;
    private String downloadLinkSpigot = "https://norska.dev/r/spigot/hm/";
    private String downloadLinkPolymart = "https://norska.dev/r/polymart/hm/";
    private String downloadLinkBBB = "https://norska.dev/r/bbb/hm/";
    private String downloadLinkModrinth = "https://norska.dev/r/modrinth/hm/";
    private final int CONNECTION_TIMEOUT_MS = 4000;
    private final URL checkURL;

    public UpdateHandler() {
        try {
            String RESOURCE_URL_TEMPLATE = "https://api.polymart.org/v1/getResourceInfoSimple?resource_id=%d&key=version";
            this.checkURL = new URL(String.format(RESOURCE_URL_TEMPLATE, this.resourceID));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public void fetchVersionFromServer(Hitmarkers main) throws Exception {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)main, () -> {
            try {
                URLConnection connection = this.checkURL.openConnection();
                connection.setConnectTimeout(4000);
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    String fetchedVersion = reader.readLine();
                    if (fetchedVersion != null && !fetchedVersion.isEmpty()) {
                        this.latestVersion = fetchedVersion.trim();
                    }
                }
            }
            catch (Exception e) {
                main.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("UPDATE_TIMEOUT", main.prefix);
            }
        });
    }

    public void checkForUpdates(Hitmarkers main) throws Exception {
        Bukkit.getScheduler().runTaskLater((Plugin)main, () -> {
            this.currentVersion = main.getDescription().getVersion();
            if (!this.currentVersion.equalsIgnoreCase(this.latestVersion)) {
                this.updateAvailable = true;
                if (main.getNHandler().getCacheHandler().getNotifyForUpdates().booleanValue()) {
                    this.sendUpdateMessage(main, (CommandSender)Bukkit.getConsoleSender(), false);
                }
            }
        }, 100L);
    }

    public void sendUpdateMessage(Hitmarkers main, CommandSender cms, Boolean join) {
        if (cms instanceof Player) {
            Player p = (Player)cms;
            if (this.updateAvailable.booleanValue()) {
                p.sendMessage("");
                p.sendMessage(IridiumColorAPI.process(" " + main.prefix + " &7New update available! &e(\u25b2)"));
                p.sendMessage(IridiumColorAPI.process(" &7Current version: &c" + this.currentVersion + " &7with latest being &a" + this.latestVersion + "&7!"));
                p.sendMessage("");
                TextComponent message1 = new TextComponent(" \u00a7a\u00a7l\u2022\u00a7r \u00a77Resource Page");
                TextComponent message1a = new TextComponent(IridiumColorAPI.process(" \u00a7e[SpigotMC]"));
                message1a.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadLinkSpigot));
                message1a.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(IridiumColorAPI.process("&a&l\u2022 &7Go to &eSpigotMC &7Resource Page...")).create()));
                message1.addExtra((BaseComponent)message1a);
                TextComponent message1b = new TextComponent(IridiumColorAPI.process(" \u00a79[Polymart]"));
                message1b.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadLinkPolymart));
                message1b.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(IridiumColorAPI.process("&a&l\u2022 &7Go to &9Polymart &7Resource Page...")).create()));
                message1.addExtra((BaseComponent)message1b);
                TextComponent message1c = new TextComponent(IridiumColorAPI.process(" \u00a7b[BuiltByBit]"));
                message1c.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadLinkBBB));
                message1c.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(IridiumColorAPI.process("&a&l\u2022 &7Go to &bBuiltByBit &7Resource Page...")).create()));
                message1.addExtra((BaseComponent)message1c);
                TextComponent message1d = new TextComponent(IridiumColorAPI.process(" \u00a7a[Modrinth]"));
                message1d.setClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, this.downloadLinkModrinth));
                message1d.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(IridiumColorAPI.process("&a&l\u2022 &7Go to &aModrinth &7Resource Page...")).create()));
                message1.addExtra((BaseComponent)message1d);
                p.spigot().sendMessage((BaseComponent)message1);
                p.sendMessage("");
            } else {
                if (join.booleanValue()) {
                    return;
                }
                p.sendMessage("");
                p.sendMessage(IridiumColorAPI.process(" " + main.prefix + " &7Running on latest &a" + this.currentVersion + "&7! &a(\u2714)"));
                p.sendMessage("");
            }
        } else if (this.updateAvailable.booleanValue()) {
            main.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("UPDATE_AVAILABLE", main.prefix, this.currentVersion, this.latestVersion, this.downloadLinkSpigot, this.downloadLinkPolymart, this.downloadLinkBBB, this.downloadLinkModrinth);
        } else {
            if (join.booleanValue()) {
                return;
            }
            main.getNHandler().getMessageFeedbackHandler().sendConsoleMessage("UPDATE_UNAVAILABLE", main.prefix, this.currentVersion);
        }
    }

    public Boolean getUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public int getResourceID() {
        return this.resourceID;
    }

    public String getDownloadLinkSpigot() {
        return this.downloadLinkSpigot;
    }

    public String getDownloadLinkPolymart() {
        return this.downloadLinkPolymart;
    }

    public String getDownloadLinkBBB() {
        return this.downloadLinkBBB;
    }

    public String getDownloadLinkModrinth() {
        return this.downloadLinkModrinth;
    }
}

