/*
 * Decompiled with CFR 0.152.
 */
package dev.norska.hm.profiles.objects;

import com.mojang.authlib.GameProfile;
import dev.norska.hm.profiles.PlayerProfiles;
import dev.norska.hm.profiles.ProfilesCore;
import dev.norska.hm.profiles.exceptions.InvalidProfileContainerException;
import dev.norska.hm.profiles.objects.DelegateProfileable;
import dev.norska.hm.profiles.objects.Profileable;
import java.util.Objects;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ProfileContainer<T>
implements Profileable {
    @NotNull
    public abstract void setProfile(@Nullable GameProfile var1);

    @NotNull
    public abstract T getObject();

    public final String toString() {
        return this.getClass().getSimpleName() + '[' + this.getObject() + ']';
    }

    public static final class BlockStateProfileContainer
    extends ProfileContainer<Skull> {
        private final Skull state;

        public BlockStateProfileContainer(Skull state) {
            this.state = Objects.requireNonNull(state, "Skull BlockState is null");
        }

        @Override
        public void setProfile(GameProfile profile) {
            try {
                ProfilesCore.CraftSkull_profile$setter.invoke(this.state, PlayerProfiles.wrapProfile(profile));
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Unable to set profile " + profile + " to " + this.state, throwable);
            }
        }

        @Override
        public Skull getObject() {
            return this.state;
        }

        @Override
        public GameProfile getProfile() {
            try {
                return PlayerProfiles.unwrapProfile(ProfilesCore.CraftSkull_profile$getter.invoke(this.state));
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Unable to get profile fr om blockstate: " + this.state, throwable);
            }
        }
    }

    public static final class BlockProfileContainer
    extends ProfileContainer<Block>
    implements DelegateProfileable {
        private final Block block;

        public BlockProfileContainer(Block block) {
            this.block = Objects.requireNonNull(block, "Block is null");
        }

        private Skull getBlockState() {
            BlockState state = this.block.getState();
            if (!(state instanceof Skull)) {
                throw new InvalidProfileContainerException(this.block, "Block can't contain texture: " + this.block);
            }
            return (Skull)state;
        }

        @Override
        public void setProfile(GameProfile profile) {
            Skull state = this.getBlockState();
            new BlockStateProfileContainer(state).setProfile(profile);
            state.update(true);
        }

        @Override
        public Block getObject() {
            return this.block;
        }

        @Override
        public Profileable getDelegateProfile() {
            return new BlockStateProfileContainer(this.getBlockState());
        }
    }

    public static final class ItemMetaProfileContainer
    extends ProfileContainer<ItemMeta> {
        private final ItemMeta meta;

        public ItemMetaProfileContainer(SkullMeta meta) {
            this.meta = (ItemMeta)Objects.requireNonNull(meta, "ItemMeta is null");
        }

        @Override
        public void setProfile(GameProfile profile) {
            try {
                ProfilesCore.CraftMetaSkull_profile$setter.invoke(this.meta, PlayerProfiles.wrapProfile(profile));
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Unable to set profile " + profile + " to " + this.meta, throwable);
            }
        }

        @Override
        public ItemMeta getObject() {
            return this.meta;
        }

        @Override
        public GameProfile getProfile() {
            try {
                return PlayerProfiles.unwrapProfile(ProfilesCore.CraftMetaSkull_profile$getter.invoke((SkullMeta)this.meta));
            }
            catch (Throwable throwable) {
                throw new IllegalStateException("Failed to get profile from item meta: " + this.meta, throwable);
            }
        }
    }

    public static final class ItemStackProfileContainer
    extends ProfileContainer<ItemStack>
    implements DelegateProfileable {
        private final ItemStack itemStack;

        public ItemStackProfileContainer(ItemStack itemStack) {
            this.itemStack = Objects.requireNonNull(itemStack, "ItemStack is null");
        }

        private ItemMetaProfileContainer getMetaContainer(ItemMeta meta) {
            if (!(meta instanceof SkullMeta)) {
                throw new InvalidProfileContainerException(this.itemStack, "Item can't contain texture: " + this.itemStack);
            }
            return new ItemMetaProfileContainer((SkullMeta)meta);
        }

        @Override
        public void setProfile(GameProfile profile) {
            ItemMeta meta = this.itemStack.getItemMeta();
            this.getMetaContainer(meta).setProfile(profile);
            this.itemStack.setItemMeta(meta);
        }

        @Override
        public ItemStack getObject() {
            return this.itemStack;
        }

        @Override
        public Profileable getDelegateProfile() {
            return this.getMetaContainer(this.itemStack.getItemMeta());
        }
    }
}

