/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports;

import dev.xf3d3.ultimatereports.commands.ReportCommand;
import dev.xf3d3.ultimatereports.commands.ReportsCommand;
import dev.xf3d3.ultimatereports.config.Dialog;
import dev.xf3d3.ultimatereports.config.Discord;
import dev.xf3d3.ultimatereports.config.GUI;
import dev.xf3d3.ultimatereports.config.Messages;
import dev.xf3d3.ultimatereports.config.Rewards;
import dev.xf3d3.ultimatereports.config.Settings;
import dev.xf3d3.ultimatereports.database.Database;
import dev.xf3d3.ultimatereports.database.SQLiteDatabase;
import dev.xf3d3.ultimatereports.discord.DiscordBot;
import dev.xf3d3.ultimatereports.discord.WebHook;
import dev.xf3d3.ultimatereports.hooks.ViaVersionHook;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.PaperCommandManager;
import dev.xf3d3.ultimatereports.libraries.bstats.bukkit.Metrics;
import dev.xf3d3.ultimatereports.libraries.bstats.charts.SimplePie;
import dev.xf3d3.ultimatereports.libraries.configlib.NameFormatters;
import dev.xf3d3.ultimatereports.libraries.configlib.YamlConfigurationProperties;
import dev.xf3d3.ultimatereports.libraries.configlib.YamlConfigurations;
import dev.xf3d3.ultimatereports.libraries.desertwell.util.ThrowingConsumer;
import dev.xf3d3.ultimatereports.libraries.desertwell.util.Version;
import dev.xf3d3.ultimatereports.libraries.folialib.FoliaLib;
import dev.xf3d3.ultimatereports.libraries.folialib.impl.PlatformScheduler;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.listeners.PlayerConnectEvent;
import dev.xf3d3.ultimatereports.listeners.PlayerDisconnectEvent;
import dev.xf3d3.ultimatereports.managers.ReportsManager;
import dev.xf3d3.ultimatereports.managers.UsersManager;
import dev.xf3d3.ultimatereports.models.Report;
import dev.xf3d3.ultimatereports.models.User;
import dev.xf3d3.ultimatereports.network.Broker;
import dev.xf3d3.ultimatereports.network.PluginMessageBroker;
import dev.xf3d3.ultimatereports.network.RedisBroker;
import dev.xf3d3.ultimatereports.utils.TaskRunner;
import dev.xf3d3.ultimatereports.utils.Utils;
import dev.xf3d3.ultimatereports.utils.gson.GsonUtils;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.plugin.messaging.PluginMessageListener;

public final class UltimateReports
extends JavaPlugin
implements TaskRunner,
GsonUtils,
PluginMessageListener {
    private static UltimateReports instance;
    public boolean loaded = false;
    private static final int METRICS_ID = 28016;
    @Nullable
    private Broker broker;
    private Database database;
    private ReportsManager reportsManager;
    private UsersManager usersManager;
    private Utils utils;
    private Settings settings;
    private Messages messages;
    private GUI guiConfig;
    private Dialog dialogConfig;
    private Rewards rewardsConfig;
    @Nullable
    private Discord discordConfig;
    @Nullable
    private ViaVersionHook viaVersionHook;
    @Nullable
    private WebHook webHookSender;
    @Nullable
    private DiscordBot discordBot;
    private FoliaLib foliaLib;
    private PaperCommandManager manager;
    YamlConfigurationProperties.Builder<?> YAML_CONFIGURATION_PROPERTIES = (YamlConfigurationProperties.Builder)((YamlConfigurationProperties.Builder)YamlConfigurationProperties.newBuilder().charset(StandardCharsets.UTF_8)).setNameFormatter(NameFormatters.LOWER_UNDERSCORE);

    public void onLoad() {
        instance = this;
    }

    public void onEnable() {
        this.foliaLib = new FoliaLib((Plugin)this);
        this.manager = new PaperCommandManager((Plugin)this);
        this.reportsManager = new ReportsManager(this);
        this.usersManager = new UsersManager(this);
        this.initialize("plugin config & locale files", plugin -> this.loadConfigs());
        this.initialize(this.getSettings().getDatabase().getType().getDisplayName() + " database connection", plugin -> {
            this.database = switch (this.getSettings().getDatabase().getType()) {
                default -> throw new MatchException(null, null);
                case Database.Type.MYSQL, Database.Type.MARIADB -> new SQLiteDatabase(this);
                case Database.Type.SQLITE -> new SQLiteDatabase(this);
                case Database.Type.H2 -> new SQLiteDatabase(this);
                case Database.Type.POSTGRESQL -> new SQLiteDatabase(this);
            };
            this.database.initialize();
        });
        if (this.getSettings().getCrossServer().isEnabled()) {
            this.initialize(String.valueOf((Object)this.getSettings().getCrossServer().getBrokerType()) + " broker", plugin -> {
                Broker.Type brokerType = this.getSettings().getCrossServer().getBrokerType();
                this.broker = switch (brokerType) {
                    default -> throw new MatchException(null, null);
                    case Broker.Type.PLUGIN_MESSAGE -> new PluginMessageBroker(this);
                    case Broker.Type.REDIS -> new RedisBroker(this);
                };
                this.broker.initialize();
            });
        }
        if (this.getSettings().getDiscord().getWebhook().isEnabled()) {
            this.initialize("Discord WebHooks", plugin -> {
                this.webHookSender = new WebHook(this);
            });
        }
        if (this.getSettings().getDiscord().getBot().isEnabled()) {
            this.initialize("Discord Bot", plugin -> {
                this.discordBot = new DiscordBot(this);
            });
        }
        this.initialize("Commands and Async command completion", plugin -> {
            this.manager.registerCommand(new ReportCommand(this));
            this.manager.registerCommand(new ReportsCommand(this));
            this.manager.getCommandCompletions().registerAsyncCompletion("onlineUsers", c -> this.getUsersManager().getUserList().stream().map(User::getUsername).collect(Collectors.toList()));
            this.manager.getCommandCompletions().registerAsyncCompletion("reports", c -> this.getReportsManager().getReports().stream().map(Report::getId).sorted().map(String::valueOf).collect(Collectors.toList()));
            this.manager.getCommandCompletions().registerAsyncCompletion("playerReports", c -> this.getReportsManager().getReports().stream().filter(report -> report.getReporter().equals(c.getPlayer().getUniqueId())).map(Report::getId).sorted().map(String::valueOf).collect(Collectors.toList()));
        });
        this.initialize("events", plugin -> {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerConnectEvent(this), (Plugin)this);
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerDisconnectEvent(this), (Plugin)this);
        });
        this.initialize("reports", plugin -> this.runAsync(task -> this.reportsManager.loadReports()));
        if (this.getServer().getPluginManager().getPlugin("ViaVersion") != null) {
            this.initialize("ViaVersion Hook", plugin -> {
                this.viaVersionHook = new ViaVersionHook();
            });
        }
        this.initialize("metrics", plugin -> this.registerMetrics(28016));
        this.utils = new Utils(this);
    }

    public void onDisable() {
    }

    public void log(@NotNull Level level, @NotNull String message, Throwable ... throwable) {
        if (throwable != null && throwable.length > 0) {
            this.getLogger().log(level, message, throwable[0]);
            return;
        }
        this.getLogger().log(level, message);
    }

    private void initialize(@NotNull String name, @NotNull ThrowingConsumer<UltimateReports> runner) {
        this.log(Level.INFO, "Initializing " + name + "...", new Throwable[0]);
        try {
            runner.accept(this);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize " + name, e);
        }
        this.log(Level.INFO, "Successfully initialized " + name, new Throwable[0]);
    }

    public void initializePluginChannels() {
        this.getServer().getMessenger().registerIncomingPluginChannel((Plugin)this, "BungeeCord", (PluginMessageListener)this);
        this.getServer().getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, @NotNull byte[] message) {
        Broker broker;
        if (this.broker != null && (broker = this.broker) instanceof PluginMessageBroker) {
            PluginMessageBroker pluginMessenger = (PluginMessageBroker)broker;
            if (this.getSettings().getCrossServer().getBrokerType() == Broker.Type.PLUGIN_MESSAGE) {
                pluginMessenger.onReceive(channel, player, message);
            }
        }
    }

    public void loadConfigs() {
        this.setSettings(YamlConfigurations.update(this.getDataFolder().toPath().resolve("config.yml"), Settings.class, ((YamlConfigurationProperties.Builder)this.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    UltimateReports Config    \u2503\n\u2503      Developed by xF3d3      \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2517\u2578 Documentation:")).build()));
        this.setMessages(YamlConfigurations.update(this.getDataFolder().toPath().resolve("messages.yml"), Messages.class, ((YamlConfigurationProperties.Builder)this.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503   UltimateReports Messages   \u2503\n\u2503      Developed by xF3d3      \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2523\u2578 Syntax: The messages are formatted with MineDown: https://github.com/Phoenix616/MineDown\n\u2517\u2578 Documentation:")).build()));
        this.setGuiConfig(YamlConfigurations.update(this.getDataFolder().toPath().resolve("gui.yml"), GUI.class, ((YamlConfigurationProperties.Builder)this.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503   UltimateReports GUI Config   \u2503\n\u2503      Developed by xF3d3        \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2517\u2578 Documentation:")).build()));
        if (this.getSettings().getDiscord().getBot().isEnabled() || this.getSettings().getDiscord().getWebhook().isEnabled()) {
            this.setDiscordConfig(YamlConfigurations.update(this.getDataFolder().toPath().resolve("discord.yml"), Discord.class, ((YamlConfigurationProperties.Builder)this.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503 UltimateReports Discord Config \u2503\n\u2503      Developed by xF3d3        \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2517\u2578 Documentation:")).build()));
        }
        if (this.getSettings().isUseDialogs()) {
            this.setDialogConfig(YamlConfigurations.update(this.getDataFolder().toPath().resolve("dialog.yml"), Dialog.class, ((YamlConfigurationProperties.Builder)this.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503  UltimateReports Dialog Config  \u2503\n\u2503      Developed by xF3d3         \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2517\u2578 Documentation:")).build()));
        }
        if (this.getSettings().isEnableRewardsSystem()) {
            this.setRewardsConfig(YamlConfigurations.update(this.getDataFolder().toPath().resolve("rewards.yml"), Rewards.class, ((YamlConfigurationProperties.Builder)this.YAML_CONFIGURATION_PROPERTIES.header("\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    UltimateReports Rewards   \u2503\n\u2503      Developed by xF3d3      \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2517\u2578 Documentation:")).build()));
        }
    }

    public void registerMetrics(int metricsId) {
        try {
            Metrics metrics = new Metrics((Plugin)this, metricsId);
            metrics.addCustomChart(new SimplePie("database_type", () -> this.getSettings().getDatabase().getType().getDisplayName()));
            metrics.addCustomChart(new SimplePie("discord_webhook", () -> Boolean.toString(this.getSettings().getDiscord().getWebhook().isEnabled())));
            metrics.addCustomChart(new SimplePie("discord_bot", () -> Boolean.toString(this.getSettings().getDiscord().getBot().isEnabled())));
            metrics.addCustomChart(new SimplePie("cross_server", () -> Boolean.toString(this.getSettings().getCrossServer().isEnabled())));
            if (this.getSettings().getCrossServer().isEnabled()) {
                metrics.addCustomChart(new SimplePie("broker_type", () -> this.getSettings().getCrossServer().getBrokerType().name().toLowerCase()));
            }
        }
        catch (Exception e) {
            this.log(Level.WARNING, "Failed to register bStats metrics", e);
        }
    }

    @NotNull
    public Version getPluginVersion() {
        return Version.fromString(plugin.getPluginMeta().getVersion());
    }

    public void sendConsole(String text) {
        Bukkit.getConsoleSender().sendMessage(MineDown.parse(text, new String[0]));
    }

    public static UltimateReports getPlugin() {
        return instance;
    }

    @NotNull
    public Optional<Broker> getMessageBroker() {
        return Optional.ofNullable(this.broker);
    }

    @NotNull
    public Optional<WebHook> getWebHookSender() {
        return Optional.ofNullable(this.webHookSender);
    }

    @NotNull
    public Optional<DiscordBot> getDiscordBot() {
        return Optional.ofNullable(this.discordBot);
    }

    @Override
    @NotNull
    public PlatformScheduler getScheduler() {
        return this.foliaLib.getScheduler();
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Generated
    public Database getDatabase() {
        return this.database;
    }

    @Generated
    public ReportsManager getReportsManager() {
        return this.reportsManager;
    }

    @Generated
    public UsersManager getUsersManager() {
        return this.usersManager;
    }

    @Generated
    public Utils getUtils() {
        return this.utils;
    }

    @Generated
    public Settings getSettings() {
        return this.settings;
    }

    @Generated
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Generated
    public Messages getMessages() {
        return this.messages;
    }

    @Generated
    public void setMessages(Messages messages) {
        this.messages = messages;
    }

    @Generated
    public GUI getGuiConfig() {
        return this.guiConfig;
    }

    @Generated
    public void setGuiConfig(GUI guiConfig) {
        this.guiConfig = guiConfig;
    }

    @Generated
    public Dialog getDialogConfig() {
        return this.dialogConfig;
    }

    @Generated
    public void setDialogConfig(Dialog dialogConfig) {
        this.dialogConfig = dialogConfig;
    }

    @Generated
    public Rewards getRewardsConfig() {
        return this.rewardsConfig;
    }

    @Generated
    public void setRewardsConfig(Rewards rewardsConfig) {
        this.rewardsConfig = rewardsConfig;
    }

    @Nullable
    @Generated
    public Discord getDiscordConfig() {
        return this.discordConfig;
    }

    @Generated
    public void setDiscordConfig(@Nullable Discord discordConfig) {
        this.discordConfig = discordConfig;
    }

    @Nullable
    @Generated
    public ViaVersionHook getViaVersionHook() {
        return this.viaVersionHook;
    }
}

