/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.commands;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.dialogs.ReportDialog;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Optional;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

@CommandAlias(value="report")
@CommandPermission(value="ultimatereports.player")
public class ReportCommand
extends BaseCommand {
    private final UltimateReports plugin;

    public ReportCommand(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    @Default
    @CommandCompletion(value="@onlineUsers [reason] @nothing")
    @CommandPermission(value="ultimatereports.report")
    public void onReport(Player player, OfflinePlayer reported, @Optional String[] reasonArgs) {
        String reason = String.join((CharSequence)" ", reasonArgs);
        this.plugin.getUsersManager().getPlayer(player.getUniqueId()).thenAccept(onlinePlayer -> {
            Player reportedPlayer;
            if (onlinePlayer.getRemainingTime() > 0L) {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getCannotUseCommandsCooldown().replace("%REMAINING%", this.plugin.getUtils().formatTime(onlinePlayer.getRemainingTime())), new String[0]));
                return;
            }
            if (reported == null) {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getPlayerNotFoundBlank(), new String[0]));
                return;
            }
            if (!this.plugin.getSettings().getGeneral().isReportOffline() && !reported.isOnline()) {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getCanReportOnlyOnline(), new String[0]));
                return;
            }
            if (player.getUniqueId().equals(reported.getUniqueId())) {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getCannotReportYourself(), new String[0]));
                return;
            }
            Player player2 = reportedPlayer = reported.isOnline() ? Bukkit.getPlayer((UUID)reported.getUniqueId()) : null;
            if (reason.isEmpty()) {
                if (this.plugin.getUsersManager().canUseDialogs(player)) {
                    new ReportDialog(this.plugin, player, reported, reportedPlayer);
                    return;
                }
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getNoReasonGiven(), new String[0]));
                return;
            }
            player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getReportSuccessful().replace("%PLAYER%", Objects.requireNonNullElse(reported.getName(), "Player not found")).replace("%REASON%", reason), new String[0]));
            this.plugin.getReportsManager().createReport(player, reported, reason, reportedPlayer);
        });
    }
}

