/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.commands;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.dialogs.CommentDialog;
import dev.xf3d3.ultimatereports.gui.ReportGui;
import dev.xf3d3.ultimatereports.gui.ReportsList;
import dev.xf3d3.ultimatereports.gui.RewardsGui;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Default;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Description;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Optional;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Subcommand;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Values;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.Set;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@CommandAlias(value="reports")
@CommandPermission(value="ultimatereports.reports")
public class ReportsCommand
extends BaseCommand {
    private final UltimateReports plugin;

    public ReportsCommand(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    @Default
    public void onReports(Player player) {
        Set<Report> reports = player.hasPermission("ultimatereports.reports.manage") ? this.plugin.getReportsManager().getOpenReports() : this.plugin.getReportsManager().getPlayerReports(player.getUniqueId());
        new ReportsList(this.plugin, player, reports, Report.Status.OPEN);
    }

    @Subcommand(value="reload")
    @CommandPermission(value="ultimatereports.reload")
    public void onReload(CommandSender sender) {
        this.plugin.loadConfigs();
        this.plugin.getUtils().setDateFormat();
        sender.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getPluginReloaded(), new String[0]));
    }

    @Subcommand(value="about")
    @CommandCompletion(value="@nothing")
    @CommandPermission(value="ultimatereports.about")
    public void aboutSubcommand(CommandSender sender) {
        sender.sendMessage(MineDown.parse("         &6UltimateReports&r         ", new String[0]));
        sender.sendMessage(MineDown.parse("&3Version: &6" + this.plugin.getPluginMeta().getVersion(), new String[0]));
        sender.sendMessage(MineDown.parse("&3Database Type: &6" + this.plugin.getSettings().getDatabase().getType().getDisplayName(), new String[0]));
        this.plugin.getMessageBroker().ifPresent(broker -> sender.sendMessage(MineDown.parse("&3Broker Type: &6" + this.plugin.getSettings().getCrossServer().getBrokerType().getDisplayName(), new String[0])));
        sender.sendMessage(MineDown.parse("&3Author: &6" + String.valueOf(this.plugin.getPluginMeta().getAuthors()), new String[0]));
        sender.sendMessage(MineDown.parse("&3Contributors: &6" + String.valueOf(this.plugin.getPluginMeta().getContributors()), new String[0]));
        sender.sendMessage(MineDown.parse("&3Description: &6" + this.plugin.getPluginMeta().getDescription(), new String[0]));
        sender.sendMessage(MineDown.parse("&3Website: https://ultimateteams.gitbook.io/ultimateteams-docs", new String[0]));
        sender.sendMessage(MineDown.parse("         &6UltimateReports&r         ", new String[0]));
    }

    @Subcommand(value="notify")
    @CommandPermission(value="ultimatereports.notify")
    public void onNotify(Player player) {
        this.plugin.getUsersManager().getPlayer(player.getUniqueId()).thenAccept(onlinePlayer -> {
            if (onlinePlayer.getPreferences().isNotifications()) {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getNotifications().getNotificationsDisabled(), new String[0]));
                onlinePlayer.getPreferences().setNotifications(false);
                this.plugin.getUsersManager().updatePlayer((OnlinePlayer)onlinePlayer);
            } else {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getNotifications().getNotificationsEnabled(), new String[0]));
                onlinePlayer.getPreferences().setNotifications(true);
                this.plugin.getUsersManager().updatePlayer((OnlinePlayer)onlinePlayer);
            }
        });
    }

    @Subcommand(value="check")
    @CommandPermission(value="ultimatereports.reports.check")
    @CommandCompletion(value="@reports @nothing")
    public void onCheck(Player player, @Values(value="@reports") int id) {
        if (this.plugin.getUsersManager().canAddComments(player, id)) {
            new ReportGui(this.plugin, player, id);
            return;
        }
        player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
    }

    @Subcommand(value="comment")
    @Description(value="Add a comment to a report")
    @CommandPermission(value="ultimatereports.reports.comment")
    @CommandCompletion(value="@reports <comment> @nothing")
    public void onComment(Player player, @Values(value="@reports") int id, @Optional String[] args) {
        if (!this.plugin.getUsersManager().canAddComments(player, id)) {
            player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
            return;
        }
        String commentText = String.join((CharSequence)" ", args);
        this.plugin.getReportsManager().getReportById(id).ifPresentOrElse(report -> {
            if (commentText.isEmpty()) {
                if (this.plugin.getUsersManager().canUseDialogs(player)) {
                    new CommentDialog(this.plugin, player, (Report)report);
                    return;
                }
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getComment().getCommentCannotBeEmpty(), new String[0]));
                return;
            }
            this.plugin.getReportsManager().addComment(player, (Report)report, commentText);
            player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getComment().getCommentAdded(), new String[0]));
        }, () -> player.sendMessage(MineDown.parse("&cReport does not exist!", new String[0])));
    }

    @Subcommand(value="cooldown add")
    @Description(value="Add a cooldown in minutes to a player")
    @CommandPermission(value="ultimatereports.cooldown.add")
    @CommandCompletion(value="@onlineUsers <minutes> @nothing")
    public void onCooldownAdd(CommandSender sender, OfflinePlayer offlinePlayer, int minutes) {
        this.plugin.getUsersManager().getPlayer(offlinePlayer.getUniqueId()).thenAccept(onlinePlayer -> {
            onlinePlayer.addCoolDown(this.plugin, minutes);
            sender.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getCooldown().getCooldownAdd().replace("%COOLDOWN%", this.plugin.getUtils().formatTime(onlinePlayer.getRemainingTime())).replace("%PLAYER%", onlinePlayer.getLastPlayerName()), new String[0]));
        });
    }

    @Subcommand(value="cooldown reset")
    @Description(value="Reset a player's cooldown")
    @CommandPermission(value="ultimatereports.cooldown.add")
    @CommandCompletion(value="@onlineUsers @nothing")
    public void onCooldownReset(CommandSender sender, OfflinePlayer offlinePlayer) {
        this.plugin.getUsersManager().getPlayer(offlinePlayer.getUniqueId()).thenAccept(onlinePlayer -> {
            onlinePlayer.getPreferences().setCooldown(0L);
            this.plugin.getUsersManager().updatePlayer((OnlinePlayer)onlinePlayer);
            sender.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getCooldown().getCooldownReset(), new String[0]));
        });
    }

    @Subcommand(value="cooldown")
    @Description(value="Check a player's cooldown")
    @CommandPermission(value="ultimatereports.cooldown.add")
    @CommandCompletion(value="@onlineUsers @nothing")
    public void onCooldownCheck(CommandSender sender, OfflinePlayer offlinePlayer) {
        this.plugin.getUsersManager().getPlayer(offlinePlayer.getUniqueId()).thenAccept(onlinePlayer -> sender.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getCooldown().getCooldownCheck().replace("%COOLDOWN%", this.plugin.getUtils().formatTime(onlinePlayer.getRemainingTime())), new String[0])));
    }

    @Subcommand(value="reward")
    @Description(value="Claim the reward for your report")
    @CommandPermission(value="ultimatereports.reward")
    @CommandCompletion(value="@nothing")
    public void onReward(Player player) {
        this.plugin.getUsersManager().getPlayer(player.getUniqueId()).thenAccept(onlinePlayer -> {
            if (onlinePlayer.getPreferences().getRewardsToClaim() < 1) {
                player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getNoRewardsToClaim(), new String[0]));
                return;
            }
            new RewardsGui(this.plugin, player, (OnlinePlayer)onlinePlayer);
        });
    }
}

