/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.config;

import dev.xf3d3.ultimatereports.libraries.configlib.Comment;
import dev.xf3d3.ultimatereports.libraries.configlib.Configuration;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@Configuration
public class Messages {
    public static final String MESSAGES_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503   UltimateReports Messages   \u2503\n\u2503      Developed by xF3d3      \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2523\u2578 Syntax: The messages are formatted with MineDown: https://github.com/Phoenix616/MineDown\n\u2517\u2578 Documentation:";
    @Comment(value={"General Messages"})
    private GeneralMessages general = new GeneralMessages();
    @Comment(value={"Report Messages"})
    private ReportMessages report = new ReportMessages();
    @Comment(value={"Notification messages"})
    private NotificationMessages notifications = new NotificationMessages();
    @Comment(value={"Comment Messages"})
    private CommentMessages comment = new CommentMessages();
    @Comment(value={"Cooldown Messages"})
    private CooldownMessages cooldown = new CooldownMessages();

    @Generated
    public GeneralMessages getGeneral() {
        return this.general;
    }

    @Generated
    public ReportMessages getReport() {
        return this.report;
    }

    @Generated
    public NotificationMessages getNotifications() {
        return this.notifications;
    }

    @Generated
    public CommentMessages getComment() {
        return this.comment;
    }

    @Generated
    public CooldownMessages getCooldown() {
        return this.cooldown;
    }

    @Generated
    private Messages() {
    }

    @Configuration
    public static class GeneralMessages {
        private String noPermission = "[You don't have the permission for this action.](dark_aqua)";
        private String cannotUseCommandsCooldown = "[You are on cooldown! You cannot use commands for another:](dark_aqua) [%REMAINING%](gold)";
        private String playerNotFound = "[Player](dark_aqua) [%PLAYER%] [not found!](dark_aqua)";
        private String playerNotFoundBlank = "[Cannot find the specified player](dark_aqua)";
        private String pluginReloaded = "[Plugin successfully reloaded](dark_aqua)";
        private String positionDoesntExist = "[The reported player was offline during the report, so there is no location to teleport to](dark_aqua)";
        private String cantTpPlayerOffline = "[The player is offline!](dark_aqua)";
        @Comment(value={"You can use this to customize the name for these status"})
        private Map<Report.Status, String> reportStatus = new LinkedHashMap<Report.Status, String>();
        @Comment(value={"You can use this to customize the name for these status"})
        private Map<Comment.MessageStatus, String> commentsStatus;
        @Comment(value={"You can use this to customize the name for the report processing"})
        private Map<Report.MarkedAs, String> reportsMarks;

        @Generated
        public String getNoPermission() {
            return this.noPermission;
        }

        @Generated
        public String getCannotUseCommandsCooldown() {
            return this.cannotUseCommandsCooldown;
        }

        @Generated
        public String getPlayerNotFound() {
            return this.playerNotFound;
        }

        @Generated
        public String getPlayerNotFoundBlank() {
            return this.playerNotFoundBlank;
        }

        @Generated
        public String getPluginReloaded() {
            return this.pluginReloaded;
        }

        @Generated
        public String getPositionDoesntExist() {
            return this.positionDoesntExist;
        }

        @Generated
        public String getCantTpPlayerOffline() {
            return this.cantTpPlayerOffline;
        }

        @Generated
        public Map<Report.Status, String> getReportStatus() {
            return this.reportStatus;
        }

        @Generated
        public Map<Comment.MessageStatus, String> getCommentsStatus() {
            return this.commentsStatus;
        }

        @Generated
        public Map<Report.MarkedAs, String> getReportsMarks() {
            return this.reportsMarks;
        }

        @Generated
        private GeneralMessages() {
            this.reportStatus.put(Report.Status.OPEN, "OPEN");
            this.reportStatus.put(Report.Status.WAITING, "WAITING");
            this.reportStatus.put(Report.Status.IN_PROGRESS, "IN PROGRESS");
            this.reportStatus.put(Report.Status.DONE, "DONE");
            this.reportStatus.put(Report.Status.ARCHIVED, "ARCHIVED");
            this.commentsStatus = new LinkedHashMap<Comment.MessageStatus, String>();
            this.commentsStatus.put(Comment.MessageStatus.NOT_READ, "NOT READ");
            this.commentsStatus.put(Comment.MessageStatus.READ, "READ");
            this.reportsMarks = new LinkedHashMap<Report.MarkedAs, String>();
            this.reportsMarks.put(Report.MarkedAs.TRUE, "TRUE");
            this.reportsMarks.put(Report.MarkedAs.FALSE, "FALSE");
        }
    }

    @Configuration
    public static class ReportMessages {
        private String canReportOnlyOnline = "[You can report only online players!](dark_aqua)";
        private String cannotReportYourself = "[You can't report yourself!](dark_aqua)";
        private String noReasonGiven = "[Please provide a reason for your report.](dark_aqua)";
        private String reportSuccessful = "[You successfully reported](dark_aqua) [%PLAYER%](gold) [for:](dark_aqua) [%REASON%](gold)";
        private String reportDeleted = "[The report has been successfully deleted](dark_aqua)";
        private String alreadyProcessed = "[The report has been already been processed!](dark_aqua)";
        private String rewards = "[One of your reports has been verified and you can claim the reward!](dark_aqua)";
        private String noRewardsToClaim = "[There are no rewards to claim!](dark_aqua)";
        private List<String> adminNotification = List.of("&7&m                                                    &r", "[New report from](dark_aqua) [%REPORTER%](gold)", "[Report info:](dark_aqua)", "", "[ID: #](dark_aqua)[%ID%](gold)", "[Reporter:](dark_aqua) [%REPORTER%](green)[, Reported:](dark_aqua) [%REPORTED%](red)", "[Reason:](dark_aqua) [%REASON%](gold)", "", "[[Click to open the report]](blue bold run_command=/reports check %ID% hover=[Click to open the report](dark_aqua))", "&7&m                                                    &r");
        private String statusUpdate = "[There is an update for your report](dark_aqua) [#%ID%](gold)[. The status has changed to:](dark_aqua) [%STATUS%](gold)";
        private String commentUpdate = "[There is an update for your report](dark_aqua) [#%ID%](gold)[. A comment has been read](dark_aqua)";
        private String newComment = "[There is an update for your report](dark_aqua) [#%ID%](gold)[. A new comment has been added](dark_aqua)";

        @Generated
        public String getCanReportOnlyOnline() {
            return this.canReportOnlyOnline;
        }

        @Generated
        public String getCannotReportYourself() {
            return this.cannotReportYourself;
        }

        @Generated
        public String getNoReasonGiven() {
            return this.noReasonGiven;
        }

        @Generated
        public String getReportSuccessful() {
            return this.reportSuccessful;
        }

        @Generated
        public String getReportDeleted() {
            return this.reportDeleted;
        }

        @Generated
        public String getAlreadyProcessed() {
            return this.alreadyProcessed;
        }

        @Generated
        public String getRewards() {
            return this.rewards;
        }

        @Generated
        public String getNoRewardsToClaim() {
            return this.noRewardsToClaim;
        }

        @Generated
        public List<String> getAdminNotification() {
            return this.adminNotification;
        }

        @Generated
        public String getStatusUpdate() {
            return this.statusUpdate;
        }

        @Generated
        public String getCommentUpdate() {
            return this.commentUpdate;
        }

        @Generated
        public String getNewComment() {
            return this.newComment;
        }

        @Generated
        private ReportMessages() {
        }
    }

    @Configuration
    public static class NotificationMessages {
        private String notificationsEnabled = "[You have successfully enabled the notifications](dark_aqua)";
        private String notificationsDisabled = "[You have successfully disabled the notifications](dark_aqua)";

        @Generated
        public String getNotificationsEnabled() {
            return this.notificationsEnabled;
        }

        @Generated
        public String getNotificationsDisabled() {
            return this.notificationsDisabled;
        }

        @Generated
        private NotificationMessages() {
        }
    }

    @Configuration
    public static class CommentMessages {
        private String commentCannotBeEmpty = "[The comment cannot be empty](dark_aqua)";
        private String commentAdded = "[Your comment has been added to the report](dark_aqua)";

        @Generated
        public String getCommentCannotBeEmpty() {
            return this.commentCannotBeEmpty;
        }

        @Generated
        public String getCommentAdded() {
            return this.commentAdded;
        }

        @Generated
        private CommentMessages() {
        }
    }

    @Configuration
    public static class CooldownMessages {
        private String cooldownAdd = "[Cooldown successfully added to](dark_aqua) [%PLAYER%](gold)[. The new player's cooldown is:](dark_aqua) [%COOLDOWN%](gold)";
        private String cooldownReset = "[The player's cooldown has been successfully reset.](dark_aqua)";
        private String cooldownCheck = "[The player's cooldown is:](dark_aqua) [%COOLDOWN%](gold)";

        @Generated
        public String getCooldownAdd() {
            return this.cooldownAdd;
        }

        @Generated
        public String getCooldownReset() {
            return this.cooldownReset;
        }

        @Generated
        public String getCooldownCheck() {
            return this.cooldownCheck;
        }

        @Generated
        private CooldownMessages() {
        }
    }
}

