/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.config;

import com.google.common.collect.Lists;
import dev.xf3d3.ultimatereports.database.Database;
import dev.xf3d3.ultimatereports.libraries.configlib.Comment;
import dev.xf3d3.ultimatereports.libraries.configlib.Configuration;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.network.Broker;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;

@Configuration
public class Settings {
    public static final String CONFIG_HEADER = "\u250f\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2513\n\u2503    UltimateReports Config    \u2503\n\u2503      Developed by xF3d3      \u2503\n\u2523\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u251b\n\u2523\u2578 Information:\n\u2517\u2578 Documentation:";
    @Comment(value={"Check for updates on startup?"})
    private boolean checkForUpdates = true;
    @Comment(value={"Use dialogs instead of GUIs/chat when possible?. Requires server version 1.21.8+", "Recommended: true (disabled by default just in case the plugin is running on older server versions)", "", "After enabling this, restart the server and check the new generated file for customization"})
    private boolean useDialogs = false;
    @Comment(value={"Should the plugin enable the rewards system to give players reward if their reports were true?", "", "Changes require to restart. A new file will be generated for customization"})
    private boolean enableRewardsSystem = false;
    @Comment(value={"Database settings"})
    private DatabaseSettings database = new DatabaseSettings();
    @Comment(value={"Cross-server settings"})
    private CrossServerSettings crossServer = new CrossServerSettings();
    @Comment(value={"General Settings"})
    private GeneralSettings general = new GeneralSettings();
    @Comment(value={"Discord Settings.", "For cross-server users: Enable this ONLY in one server! Changes might require to restart the server.", "You can use webhooks, for just sending reports", "Or the bot to also be able to modify/answer/delete reports from Discord", "", "After you enable either (or both) of these options, restart the server and a new", "file will be generated to allow customization"})
    private DiscordSettings discord = new DiscordSettings();

    @Generated
    public boolean isCheckForUpdates() {
        return this.checkForUpdates;
    }

    @Generated
    public boolean isUseDialogs() {
        return this.useDialogs;
    }

    @Generated
    public boolean isEnableRewardsSystem() {
        return this.enableRewardsSystem;
    }

    @Generated
    public DatabaseSettings getDatabase() {
        return this.database;
    }

    @Generated
    public CrossServerSettings getCrossServer() {
        return this.crossServer;
    }

    @Generated
    public GeneralSettings getGeneral() {
        return this.general;
    }

    @Generated
    public DiscordSettings getDiscord() {
        return this.discord;
    }

    @Generated
    private Settings() {
    }

    @Configuration
    public static class DatabaseSettings {
        @Comment(value={"Type of database to use (SQLITE, MYSQL, MARIADB, H2, POSTGRESQL)"})
        private Database.Type type = Database.Type.H2;
        @Comment(value={"Specify credentials here for your MYSQL/MARIADB/POSTGRESQL database"})
        private DatabaseCredentials credentials = new DatabaseCredentials();
        @Comment(value={"Hikari connection pool properties. Don't modify this unless you know what you're doing!"})
        private PoolOptions connectionPool = new PoolOptions();
        @Comment(value={"Names of tables to use on your database. Don't modify this unless you know what you're doing!"})
        private Map<String, String> tableNames = Database.TableName.getDefaults();

        @NotNull
        public String getTableName(@NotNull Database.TableName tableName) {
            return this.tableNames.getOrDefault(tableName.name().toLowerCase(Locale.ENGLISH), tableName.getDefaultName());
        }

        @Generated
        public Database.Type getType() {
            return this.type;
        }

        @Generated
        public DatabaseCredentials getCredentials() {
            return this.credentials;
        }

        @Generated
        public PoolOptions getConnectionPool() {
            return this.connectionPool;
        }

        @Generated
        private DatabaseSettings() {
        }

        @Configuration
        public static class DatabaseCredentials {
            private String host = "localhost";
            private int port = 3306;
            private String database = "UltimateReports";
            private String username = "root";
            private String password = "pa55w0rd";
            private String parameters = String.join((CharSequence)"&", "?autoReconnect=true", "useSSL=false", "useUnicode=true", "characterEncoding=UTF-8");

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public String getDatabase() {
                return this.database;
            }

            @Generated
            public String getUsername() {
                return this.username;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public String getParameters() {
                return this.parameters;
            }

            @Generated
            private DatabaseCredentials() {
            }
        }

        @Configuration
        public static class PoolOptions {
            private int size = 8;
            private int idle = 8;
            private long lifetime = 1800000L;
            private long keepalive = 30000L;
            private long timeout = 3000L;

            @Generated
            public int getSize() {
                return this.size;
            }

            @Generated
            public int getIdle() {
                return this.idle;
            }

            @Generated
            public long getLifetime() {
                return this.lifetime;
            }

            @Generated
            public long getKeepalive() {
                return this.keepalive;
            }

            @Generated
            public long getTimeout() {
                return this.timeout;
            }

            @Generated
            private PoolOptions() {
            }
        }
    }

    @Configuration
    public static class CrossServerSettings {
        @Comment(value={"Whether to enable cross-server mode"})
        private boolean enabled = false;
        @Comment(value={"The server name in the Bungee/Velocity config. case-sensitive"})
        private String serverName = "Survival-1";
        @Comment(value={"The cluster ID, used if you want multiple separate groups of UltimateReports servers.", "Do not change unless you know what you're doing, check the wiki for better explanation"})
        private String clusterId = "main";
        @Comment(value={"Type of network message broker to ues for data synchronization (PLUGIN_MESSAGE or REDIS)", "Always use REDIS if possible"})
        private Broker.Type brokerType = Broker.Type.PLUGIN_MESSAGE;
        @Comment(value={"Settings for if you're using REDIS as your message broker"})
        private RedisSettings redis = new RedisSettings();

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public String getServerName() {
            return this.serverName;
        }

        @Generated
        public String getClusterId() {
            return this.clusterId;
        }

        @Generated
        public Broker.Type getBrokerType() {
            return this.brokerType;
        }

        @Generated
        public RedisSettings getRedis() {
            return this.redis;
        }

        @Generated
        private CrossServerSettings() {
        }

        @Configuration
        public static class RedisSettings {
            private String host = "localhost";
            private int port = 6379;
            @Comment(value={"Password for your Redis server. Leave blank if you're not using a password."})
            private String password = "";
            private boolean useSsl = false;
            @Comment(value={"Settings for if you're using Redis Sentinels.", "If you're not sure what this is, please ignore this section."})
            private SentinelSettings sentinel = new SentinelSettings();

            @Generated
            public String getHost() {
                return this.host;
            }

            @Generated
            public int getPort() {
                return this.port;
            }

            @Generated
            public String getPassword() {
                return this.password;
            }

            @Generated
            public boolean isUseSsl() {
                return this.useSsl;
            }

            @Generated
            public SentinelSettings getSentinel() {
                return this.sentinel;
            }

            @Generated
            public RedisSettings() {
            }

            @Configuration
            public static class SentinelSettings {
                private String masterName = "";
                @Comment(value={"List of host:port pairs"})
                private List<String> nodes = Lists.newArrayList();
                private String password = "";

                @Generated
                public String getMasterName() {
                    return this.masterName;
                }

                @Generated
                public List<String> getNodes() {
                    return this.nodes;
                }

                @Generated
                public String getPassword() {
                    return this.password;
                }

                @Generated
                public SentinelSettings() {
                }
            }
        }
    }

    @Configuration
    public static class GeneralSettings {
        @Comment(value={"the plugin prefix"})
        private String prefix = "[UltimateReports](gold bold) [\u00bb](gray) ";
        @Comment(value={"The format used to show dates"})
        private String dateFormat = "dd/MM/yyyy HH:mm:ss";
        @Comment(value={"Allow players to report offline players?"})
        private boolean reportOffline = true;
        @Comment(value={"default cooldown for punishments. in minutes"})
        private int defaultCooldown = 30;
        @Comment(value={"Should the plugin send notifications to the Reporter when the report is updated?"})
        private boolean sendNotification = true;

        @Generated
        public String getPrefix() {
            return this.prefix;
        }

        @Generated
        public String getDateFormat() {
            return this.dateFormat;
        }

        @Generated
        public boolean isReportOffline() {
            return this.reportOffline;
        }

        @Generated
        public int getDefaultCooldown() {
            return this.defaultCooldown;
        }

        @Generated
        public boolean isSendNotification() {
            return this.sendNotification;
        }

        @Generated
        private GeneralSettings() {
        }
    }

    @Configuration
    public static class DiscordSettings {
        @Comment(value={"WebHook settings"})
        private WebHookSettings webhook = new WebHookSettings();
        @Comment(value={"Bot settings. Check the wiki for further information"})
        private BotSettings bot = new BotSettings();

        @Generated
        public WebHookSettings getWebhook() {
            return this.webhook;
        }

        @Generated
        public BotSettings getBot() {
            return this.bot;
        }

        @Generated
        private DiscordSettings() {
        }

        @Configuration
        public static class WebHookSettings {
            @Comment(value={"Enable webhook?"})
            private boolean enabled = false;
            @Comment(value={"New Reports Webhook URL"})
            private String reportsWebHookUrl = "";
            @Comment(value={"New Comments Webhook URL"})
            private String commentsWebHookUrl = "";

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public String getReportsWebHookUrl() {
                return this.reportsWebHookUrl;
            }

            @Generated
            public String getCommentsWebHookUrl() {
                return this.commentsWebHookUrl;
            }

            @Generated
            private WebHookSettings() {
            }
        }

        @Configuration
        public static class BotSettings {
            @Comment(value={"Enable the bot?"})
            private boolean enabled = false;
            @Comment(value={"Bot token"})
            private String token = "";
            @Comment(value={"The ID for the Guild where you will be using the bot"})
            private String guildId = "";
            @Comment(value={"The channel ID to send new reports to"})
            private String reportsChannelId = "";
            @Comment(value={"Should the plugin also send a message for new Comments?"})
            private boolean sendNewComments = false;
            @Comment(value={"The channel ID to send new comments to"})
            private String commentsChannelId = "";

            @Generated
            public boolean isEnabled() {
                return this.enabled;
            }

            @Generated
            public String getToken() {
                return this.token;
            }

            @Generated
            public String getGuildId() {
                return this.guildId;
            }

            @Generated
            public String getReportsChannelId() {
                return this.reportsChannelId;
            }

            @Generated
            public boolean isSendNewComments() {
                return this.sendNewComments;
            }

            @Generated
            public String getCommentsChannelId() {
                return this.commentsChannelId;
            }

            @Generated
            private BotSettings() {
            }
        }
    }
}

