/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.database;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.intellij.lang.annotations.Language;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Position;
import dev.xf3d3.ultimatereports.models.Report;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public abstract class Database {
    protected final UltimateReports plugin;
    private boolean loaded;

    protected Database(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    @NotNull
    protected final String[] getSchema(@NotNull String schemaFileName) throws IOException {
        return this.format(new String(Objects.requireNonNull(this.plugin.getResource(schemaFileName)).readAllBytes(), StandardCharsets.UTF_8)).split(";");
    }

    @NotNull
    protected final String format(@NotNull @Language(value="SQL") String statement) {
        Pattern pattern = Pattern.compile("%(\\w+)%");
        Matcher matcher = pattern.matcher(statement);
        StringBuilder sb = new StringBuilder();
        while (matcher.find()) {
            TableName tableName = TableName.match(matcher.group(1));
            matcher.appendReplacement(sb, this.plugin.getSettings().getDatabase().getTableName(tableName));
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public abstract void initialize();

    public abstract List<Report> loadReports();

    public abstract Optional<Report> getReport(int var1);

    public abstract Report createReport(@NotNull Player var1, @NotNull OfflinePlayer var2, @NotNull String var3, @NotNull Position var4, @Nullable Position var5);

    public abstract void updateReport(@NotNull Report var1);

    public abstract void deleteReport(int var1);

    public abstract Optional<OnlinePlayer> getPlayer(@NotNull UUID var1);

    public abstract void updatePlayer(@NotNull OnlinePlayer var1);

    public abstract void createPlayer(@NotNull OnlinePlayer var1);

    public abstract void close();

    public boolean hasLoaded() {
        return this.loaded;
    }

    protected void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    public static enum TableName {
        REPORTS_DATA("ultimatereports_reports"),
        USER_DATA("ultimatereports_users");

        @NotNull
        private final String defaultName;

        private TableName(String defaultName) {
            this.defaultName = defaultName;
        }

        @NotNull
        public static TableName match(@NotNull String placeholder) throws IllegalArgumentException {
            return TableName.valueOf(placeholder.toUpperCase());
        }

        @NotNull
        private Map.Entry<String, String> toEntry() {
            return Map.entry(this.name().toLowerCase(Locale.ENGLISH), this.defaultName);
        }

        @NotNull
        public static Map<String, String> getDefaults() {
            return Map.ofEntries((Map.Entry[])Arrays.stream(TableName.values()).map(TableName::toEntry).toArray(Map.Entry[]::new));
        }

        @NotNull
        @Generated
        public String getDefaultName() {
            return this.defaultName;
        }
    }

    public static enum Type {
        MYSQL("MySQL", "mysql"),
        MARIADB("MariaDB", "mariadb"),
        SQLITE("SQLite", "sqlite"),
        H2("H2", "h2"),
        POSTGRESQL("PostgreSQL", "postgresql");

        private final String displayName;
        private final String protocol;

        @Generated
        public String getDisplayName() {
            return this.displayName;
        }

        @Generated
        public String getProtocol() {
            return this.protocol;
        }

        @Generated
        private Type(String displayName, String protocol) {
            this.displayName = displayName;
            this.protocol = protocol;
        }
    }
}

