/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.database;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.database.Database;
import dev.xf3d3.ultimatereports.libraries.gson.JsonSyntaxException;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Position;
import dev.xf3d3.ultimatereports.models.Report;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.sqlite.SQLiteConfig;

public class SQLiteDatabase
extends Database {
    private static final String DATABASE_FILE_NAME = "UltimateReportsData.db";
    private final File databaseFile;
    private Connection connection;

    public SQLiteDatabase(@NotNull UltimateReports plugin) {
        super(plugin);
        this.databaseFile = new File(plugin.getDataFolder(), DATABASE_FILE_NAME);
    }

    private Connection getConnection() throws SQLException {
        if (this.connection == null) {
            this.setConnection();
        } else if (this.connection.isClosed()) {
            this.setConnection();
        }
        return this.connection;
    }

    private void setConnection() {
        try {
            if (this.databaseFile.createNewFile()) {
                this.plugin.log(Level.INFO, "Created the SQLite database file", new Throwable[0]);
            }
            Class.forName("org.sqlite.JDBC");
            SQLiteConfig config = new SQLiteConfig();
            config.enforceForeignKeys(true);
            config.setEncoding(SQLiteConfig.Encoding.UTF8);
            config.setJournalMode(SQLiteConfig.JournalMode.WAL);
            config.setSynchronous(SQLiteConfig.SynchronousMode.FULL);
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + this.databaseFile.getAbsolutePath(), config.toProperties());
        }
        catch (IOException e) {
            this.plugin.log(Level.SEVERE, "An exception occurred creating the database file", e);
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "An SQL exception occurred initializing the SQLite database", e);
        }
        catch (ClassNotFoundException e) {
            this.plugin.log(Level.SEVERE, "Failed to load the necessary SQLite driver", e);
        }
    }

    @Override
    public void initialize() {
        this.setConnection();
        try (Statement statement = this.getConnection().createStatement();){
            for (String tableCreationStatement : this.getSchema("database/sqlite_schema.sql")) {
                statement.execute(tableCreationStatement);
            }
            this.setLoaded(true);
        }
        catch (IOException | SQLException e) {
            this.setLoaded(false);
            throw new IllegalStateException("Failed to create SQLite database tables.", e);
        }
        this.plugin.getLogger().info("Database tables created");
    }

    @Override
    public List<Report> loadReports() {
        ArrayList<Report> reports = new ArrayList<Report>();
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT `id`, `data`\nFROM `%reports_data%`\n"));){
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
                Report report = this.plugin.getGson().fromJson(data, Report.class);
                if (report == null) continue;
                report.setId(resultSet.getInt("id"));
                reports.add(report);
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to fetch list of reports from table", e);
        }
        return reports;
    }

    @Override
    public Report createReport(@NotNull Player reporter, @NotNull OfflinePlayer reported, @NotNull String reason, @NotNull Position reporterPosition, @Nullable Position reportedPosition) {
        Report report = Report.create(reporter, reported, reason, reporterPosition, reportedPosition);
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%reports_data%` (`data`)\nVALUES (?)\n"), 1);){
            statement.setBytes(1, this.plugin.getGson().toJson(report).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
            ResultSet insertedRow = statement.getGeneratedKeys();
            if (insertedRow.next()) {
                report.setId(insertedRow.getInt(1));
            }
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create report in table", e);
        }
        return report;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<Report> getReport(int id) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT *\nFROM `%reports_data%`\nWHERE `id` = ?\n"));){
            statement.setInt(1, id);
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            String data = new String(resultSet.getBytes("data"), StandardCharsets.UTF_8);
            Report report = this.plugin.getGson().fromJson(data, Report.class);
            if (report == null) return Optional.empty();
            report.setId(resultSet.getInt("id"));
            Optional<Report> optional = Optional.of(report);
            return optional;
        }
        catch (JsonSyntaxException | SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to get report from table", e);
        }
        return Optional.empty();
    }

    @Override
    public void updateReport(@NotNull Report report) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%reports_data%`\nSET `data` = ?\nWHERE `id` = ?\n"));){
            statement.setBytes(1, this.plugin.getGson().toJson(report).getBytes(StandardCharsets.UTF_8));
            statement.setInt(2, report.getId());
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update report in table", e);
        }
    }

    @Override
    public void deleteReport(int id) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("DELETE FROM `%reports_data%`\nWHERE `id` = ?\n"));){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to delete report in table", e);
        }
    }

    @Override
    public void createPlayer(@NotNull OnlinePlayer onlinePlayer) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("INSERT INTO `%user_data%` (`uuid`, `username`, `preferences`)\nVALUES (?, ?, ?)\n"));){
            statement.setString(1, String.valueOf(onlinePlayer.getUuid()));
            statement.setString(2, onlinePlayer.getLastPlayerName());
            statement.setBytes(3, this.plugin.getGson().toJson(onlinePlayer.getPreferences()).getBytes(StandardCharsets.UTF_8));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to create player in table", e);
        }
    }

    @Override
    public void updatePlayer(@NotNull OnlinePlayer onlinePlayer) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("UPDATE `%user_data%`\nSET `username` = ?, `preferences` = ?\nWHERE `uuid` = ?\n"));){
            statement.setString(1, onlinePlayer.getLastPlayerName());
            statement.setBytes(2, this.plugin.getGson().toJson(onlinePlayer.getPreferences()).getBytes(StandardCharsets.UTF_8));
            statement.setString(3, String.valueOf(onlinePlayer.getUuid()));
            statement.executeUpdate();
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to update player in table", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Optional<OnlinePlayer> getPlayer(@NotNull UUID uuid) {
        try (Connection connection = this.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.format("SELECT *\nFROM `%user_data%`\nWHERE `uuid` = ?\n"));){
            statement.setString(1, String.valueOf(uuid));
            ResultSet resultSet = statement.executeQuery();
            if (!resultSet.next()) return Optional.empty();
            OnlinePlayer onlinePlayer = new OnlinePlayer(UUID.fromString(resultSet.getString("uuid")), resultSet.getString("username"), this.plugin.getPreferencesFromJson(new String(resultSet.getBytes("preferences"), StandardCharsets.UTF_8)));
            Optional<OnlinePlayer> optional = Optional.of(onlinePlayer);
            return optional;
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to get player from table", e);
        }
        return Optional.empty();
    }

    @Override
    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            this.plugin.log(Level.SEVERE, "Failed to close connection", e);
        }
    }
}

