/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.dialogs;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.Report;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.List;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.entity.Player;

public class CommentDialog {
    private final UltimateReports plugin;
    private final Player player;
    private final Report report;

    public CommentDialog(@NotNull UltimateReports plugin, @NotNull Player player, @NotNull Report report) {
        this.plugin = plugin;
        this.player = player;
        this.report = report;
        this.open();
    }

    private void open() {
        Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)MineDown.parse(this.plugin.getDialogConfig().getComments().getTitle().replace("%ID%", String.valueOf(this.report.getId())), new String[0])).inputs(List.of(DialogInput.text((String)"comment", (int)this.plugin.getDialogConfig().getComments().getComment().getWidth(), (Component)MineDown.parse(this.plugin.getDialogConfig().getComments().getComment().getTitle(), new String[0]), (boolean)true, (String)this.plugin.getDialogConfig().getComments().getComment().getDefaultText(), (int)this.plugin.getDialogConfig().getComments().getComment().getMaxLength(), null))).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)MineDown.parse(this.plugin.getDialogConfig().getComments().getButtons().getConfirmation().getName(), new String[0]), (Component)MineDown.parse(this.plugin.getDialogConfig().getComments().getButtons().getConfirmation().getHover(), new String[0]), (int)100, (DialogAction)DialogAction.customClick((view, audience) -> {
            String comment = view.getText("comment");
            if (comment == null) {
                return;
            }
            if (audience instanceof Player) {
                Player dialogPlayer = (Player)audience;
                this.plugin.getReportsManager().addComment(this.player, this.report, comment);
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()))), (ActionButton)ActionButton.create((Component)MineDown.parse(this.plugin.getDialogConfig().getComments().getButtons().getDiscard().getName(), new String[0]), (Component)MineDown.parse(this.plugin.getDialogConfig().getComments().getButtons().getDiscard().getName(), new String[0]), (int)100, null))));
        this.player.showDialog((DialogLike)dialog);
    }
}

