/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.dialogs;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.data.dialog.ActionButton;
import io.papermc.paper.registry.data.dialog.DialogBase;
import io.papermc.paper.registry.data.dialog.DialogRegistryEntry;
import io.papermc.paper.registry.data.dialog.action.DialogAction;
import io.papermc.paper.registry.data.dialog.input.DialogInput;
import io.papermc.paper.registry.data.dialog.type.DialogType;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.Objects;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickCallback;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ReportDialog {
    private final UltimateReports plugin;
    private final Player player;
    private final OfflinePlayer reported;
    @Nullable
    private final Player reportedPlayer;

    public ReportDialog(@NotNull UltimateReports plugin, @NotNull Player player, @NotNull OfflinePlayer reported, @Nullable Player reportedPlayer) {
        this.plugin = plugin;
        this.player = player;
        this.reported = reported;
        this.reportedPlayer = reportedPlayer;
        this.open();
    }

    private void open() {
        Dialog dialog = Dialog.create(builder -> ((DialogRegistryEntry.Builder)builder.empty()).base(DialogBase.builder((Component)MineDown.parse(this.plugin.getDialogConfig().getReport().getTitle(), new String[0])).inputs(List.of(DialogInput.text((String)"reason", (int)this.plugin.getDialogConfig().getReport().getReason().getWidth(), (Component)MineDown.parse(this.plugin.getDialogConfig().getReport().getReason().getTitle(), new String[0]), (boolean)true, (String)this.plugin.getDialogConfig().getReport().getReason().getDefaultText(), (int)this.plugin.getDialogConfig().getReport().getReason().getMaxLength(), null))).build()).type((DialogType)DialogType.confirmation((ActionButton)ActionButton.create((Component)MineDown.parse(this.plugin.getDialogConfig().getReport().getButtons().getConfirmation().getName(), new String[0]), (Component)MineDown.parse(this.plugin.getDialogConfig().getReport().getButtons().getConfirmation().getHover(), new String[0]), (int)100, (DialogAction)DialogAction.customClick((view, audience) -> {
            String reason = view.getText("reason");
            if (reason == null) {
                this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getNoReasonGiven(), new String[0]));
                return;
            }
            if (audience instanceof Player) {
                Player dialogPlayer = (Player)audience;
                this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getReportSuccessful().replace("%PLAYER%", Objects.requireNonNullElse(this.reported.getName(), "Player not found")).replace("%REASON%", reason), new String[0]));
                this.plugin.getReportsManager().createReport(dialogPlayer, this.reported, reason, this.reportedPlayer);
            }
        }, (ClickCallback.Options)((ClickCallback.Options)ClickCallback.Options.builder().uses(1).lifetime((TemporalAmount)ClickCallback.DEFAULT_LIFETIME).build()))), (ActionButton)ActionButton.create((Component)MineDown.parse(this.plugin.getDialogConfig().getReport().getButtons().getDiscard().getName(), new String[0]), (Component)MineDown.parse(this.plugin.getDialogConfig().getReport().getButtons().getDiscard().getHover(), new String[0]), (int)100, null))));
        this.player.showDialog((DialogLike)dialog);
    }
}

