/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.discord;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.discord.bot.ButtonListener;
import dev.xf3d3.ultimatereports.discord.bot.DiscordBotSender;
import dev.xf3d3.ultimatereports.discord.bot.SlashCommandListener;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import java.util.Collections;
import java.util.logging.Level;
import lombok.Generated;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.interactions.commands.DefaultMemberPermissions;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.CommandData;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.utils.ChunkingFilter;
import net.dv8tion.jda.api.utils.MemberCachePolicy;
import net.dv8tion.jda.api.utils.cache.CacheFlag;

public class DiscordBot {
    private final UltimateReports plugin;
    private final DiscordBotSender embedSender;
    private JDA jda;

    public DiscordBot(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
        this.embedSender = new DiscordBotSender(plugin);
        this.start();
    }

    private void start() {
        this.plugin.runAsync(task -> {
            try {
                this.jda = JDABuilder.createLight((String)this.plugin.getSettings().getDiscord().getBot().getToken(), Collections.emptyList()).setMemberCachePolicy(MemberCachePolicy.NONE).setChunkingFilter(ChunkingFilter.NONE).disableCache(CacheFlag.ACTIVITY, new CacheFlag[]{CacheFlag.CLIENT_STATUS, CacheFlag.EMOJI, CacheFlag.MEMBER_OVERRIDES, CacheFlag.ROLE_TAGS, CacheFlag.STICKER, CacheFlag.ONLINE_STATUS, CacheFlag.FORUM_TAGS, CacheFlag.SCHEDULED_EVENTS, CacheFlag.VOICE_STATE}).addEventListeners(new Object[]{new SlashCommandListener(this.plugin)}).addEventListeners(new Object[]{new ButtonListener(this.plugin)}).build();
                this.jda.awaitReady();
                Guild guild = this.jda.getGuildById(this.plugin.getSettings().getDiscord().getBot().getGuildId());
                if (guild == null) {
                    this.plugin.log(Level.SEVERE, "The provided guild id is invalid!", new Throwable[0]);
                    return;
                }
                guild.updateCommands().addCommands(new CommandData[]{Commands.slash((String)"reports", (String)"Get reports list").setDefaultPermissions(DefaultMemberPermissions.enabledFor((Permission[])new Permission[]{Permission.MODERATE_MEMBERS})).addSubcommands(new SubcommandData[]{new SubcommandData("check", "Check a specific report").addOption(OptionType.INTEGER, "id", "the report id", true)})}).queue(success -> this.plugin.log(Level.INFO, "Discord slash commands registered", new Throwable[0]), error -> this.plugin.log(Level.SEVERE, "error while registering discord commands. Check the guild id", (Throwable)error));
                this.plugin.log(Level.INFO, "Discord Bot started", new Throwable[0]);
            }
            catch (InterruptedException e) {
                this.plugin.log(Level.SEVERE, "Error while starting the Discord bot", e);
            }
        });
    }

    @Generated
    public DiscordBotSender getEmbedSender() {
        return this.embedSender;
    }

    @Generated
    public JDA getJda() {
        return this.jda;
    }
}

