/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.discord.bot;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.Optional;
import java.util.UUID;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import org.bukkit.entity.Player;

public class ButtonListener
extends ListenerAdapter {
    private final UltimateReports plugin;

    public ButtonListener(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    public void onButtonInteraction(@NotNull ButtonInteractionEvent event) {
        int reportId;
        String[] args = event.getComponentId().split(":");
        try {
            reportId = Integer.parseInt(args[1]);
        }
        catch (NumberFormatException e) {
            event.reply("Cannot find the report! Probably it has been deleted by another staffer").setEphemeral(true).queue();
            return;
        }
        event.deferReply().setEphemeral(true).queue();
        Optional<Report> optionalReport = this.plugin.getReportsManager().getReportById(reportId);
        if (optionalReport.isEmpty()) {
            event.getHook().sendMessage("\u274c Report #" + reportId + " non trovato (forse \u00e8 stato eliminato).").queue();
            event.getMessage().editMessageComponents(new MessageTopLevelComponent[0]).queue();
            return;
        }
        Report report = optionalReport.get();
        String action = args[0];
        if (args.length == 2) {
            this.reportInteraction(event, report, action);
        } else if (args.length == 3) {
            UUID uuid = UUID.fromString(args[2]);
            Optional<Comment> comment = report.getComment(uuid);
            if (comment.isEmpty()) {
                event.getHook().sendMessage("\u274c Commento non trovato (forse \u00e8 stato eliminato).").queue();
                return;
            }
            this.commentInteraction(event, report, comment.get(), action);
        }
    }

    private void commentInteraction(@NotNull ButtonInteractionEvent event, @NotNull Report report, @NotNull Comment comment, @NotNull String action) {
        switch (action) {
            case "read": {
                comment.setStatus(Comment.MessageStatus.READ);
                report.addOrUpdateComment(comment);
                this.plugin.runSync(task -> {
                    Player randomPlayer = this.plugin.getUsersManager().getRandomPlayer();
                    this.plugin.getReportsManager().notifyReporter(report, this.plugin.getMessages().getReport().getCommentUpdate());
                    this.plugin.runAsync(task1 -> this.plugin.getReportsManager().updateReportData(randomPlayer, report));
                });
                if (this.plugin.getDiscordBot().isEmpty()) {
                    return;
                }
                ((MessageEditAction)event.getMessage().editMessageEmbeds(new MessageEmbed[]{this.plugin.getDiscordBot().get().getEmbedSender().getCommentsEmbed(report, comment)}).setComponents(new MessageTopLevelComponent[]{ActionRow.of(this.plugin.getDiscordBot().get().getEmbedSender().getCommentsButtons(report, comment))})).queue();
                event.getHook().sendMessage("\u2705 Comment impostato su **READ**.").queue();
                break;
            }
            case "delete": {
                report.removeComment(comment.getId());
                this.plugin.runSync(task -> {
                    Player randomPlayer = this.plugin.getUsersManager().getRandomPlayer();
                    this.plugin.runAsync(task1 -> this.plugin.getReportsManager().updateReportData(randomPlayer, report));
                });
                this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(report));
                event.getHook().sendMessage("\u2705 Comment cancellato").queue();
            }
        }
    }

    private void reportInteraction(@NotNull ButtonInteractionEvent event, @NotNull Report report, @NotNull String action) {
        boolean updateMessage = false;
        switch (action) {
            case "waiting": {
                if (report.getStatus() == Report.Status.WAITING) {
                    return;
                }
                report.setStatus(Report.Status.WAITING);
                updateMessage = true;
                event.getHook().sendMessage("\u2705 Report impostato su **Waiting**.").queue();
                break;
            }
            case "progress": {
                if (report.getStatus() == Report.Status.IN_PROGRESS) {
                    return;
                }
                report.setStatus(Report.Status.IN_PROGRESS);
                updateMessage = true;
                event.getHook().sendMessage("\ud83d\udea7 Report impostato su **In Progress**.").queue();
                break;
            }
            case "done": {
                if (report.getStatus() == Report.Status.DONE) {
                    return;
                }
                report.setStatus(Report.Status.DONE);
                updateMessage = true;
                event.getHook().sendMessage("\u2705 Report segnato come **Completato**.").queue();
                break;
            }
            case "archive": {
                if (report.getStatus() == Report.Status.ARCHIVED) {
                    return;
                }
                report.setStatus(Report.Status.ARCHIVED);
                updateMessage = true;
                event.getHook().sendMessage("\ud83d\udcc2 Report **Archiviato**.").queue();
                break;
            }
            case "delete": {
                this.plugin.runSync(task -> {
                    Player player = this.plugin.getUsersManager().getRandomPlayer();
                    this.plugin.getReportsManager().deleteReport(player, report);
                });
                event.getHook().sendMessage("\ud83d\uddd1\ufe0f Report eliminato definitivamente.").queue();
                event.getMessage().delete().queue();
                return;
            }
        }
        if (updateMessage) {
            this.plugin.runSync(task -> {
                Player randomPlayer = this.plugin.getUsersManager().getRandomPlayer();
                this.plugin.getReportsManager().notifyReporter(report, this.plugin.getMessages().getReport().getStatusUpdate());
                this.plugin.runAsync(task1 -> this.plugin.getReportsManager().updateReportData(randomPlayer, report));
            });
            if (this.plugin.getDiscordBot().isEmpty()) {
                return;
            }
            ((MessageEditAction)event.getMessage().editMessageEmbeds(new MessageEmbed[]{this.plugin.getDiscordBot().get().getEmbedSender().getReportEmbed(report)}).setComponents(new MessageTopLevelComponent[]{ActionRow.of(this.plugin.getDiscordBot().get().getEmbedSender().getReportButtons(report))})).queue();
        }
    }
}

