/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.discord.bot;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.config.Discord;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.Report;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import java.util.List;
import java.util.logging.Level;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.components.MessageTopLevelComponent;
import net.dv8tion.jda.api.components.actionrow.ActionRow;
import net.dv8tion.jda.api.components.buttons.Button;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.requests.restaction.MessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import org.bukkit.entity.Player;

public class DiscordBotSender {
    private final UltimateReports plugin;

    public DiscordBotSender(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    public void sendReportEmbed(@NotNull Report report) {
        if (this.plugin.getDiscordBot().isEmpty()) {
            return;
        }
        String channelId = this.plugin.getSettings().getDiscord().getBot().getReportsChannelId();
        if (channelId == null || channelId.isEmpty()) {
            this.plugin.log(Level.WARNING, "Discord Log Channel ID is empty, cannot send Embed.", new Throwable[0]);
            return;
        }
        TextChannel channel = this.plugin.getDiscordBot().get().getJda().getTextChannelById(channelId);
        if (channel == null) {
            this.plugin.log(Level.WARNING, "Discord Log Channel not found! Check the ID: " + channelId, new Throwable[0]);
            return;
        }
        ((MessageCreateAction)channel.sendMessageEmbeds(this.getReportEmbed(report), new MessageEmbed[0]).addComponents(new MessageTopLevelComponent[]{ActionRow.of(this.getReportButtons(report))})).queue(message -> this.plugin.runSync(task -> {
            Player randomPlayer = this.plugin.getUsersManager().getRandomPlayer();
            report.setDiscordMessageId(message.getId());
            this.plugin.runAsync(task1 -> this.plugin.getReportsManager().updateReportData(randomPlayer, report));
        }));
    }

    public void updateReportMessage(@NotNull Report report) {
        String msgId = report.getDiscordMessageId();
        if (msgId == null || this.plugin.getDiscordBot().isEmpty()) {
            return;
        }
        TextChannel channel = this.plugin.getDiscordBot().get().getJda().getTextChannelById(this.plugin.getSettings().getDiscord().getBot().getReportsChannelId());
        if (channel == null) {
            return;
        }
        channel.retrieveMessageById(msgId).queue(message -> ((MessageEditAction)message.editMessageEmbeds(new MessageEmbed[]{this.getReportEmbed(report)}).setComponents(new MessageTopLevelComponent[]{ActionRow.of(this.getReportButtons(report))})).queue());
    }

    public void deleteReportMessage(@NotNull Report report) {
        String msgId = report.getDiscordMessageId();
        if (msgId == null || this.plugin.getDiscordBot().isEmpty()) {
            return;
        }
        TextChannel channel = this.plugin.getDiscordBot().get().getJda().getTextChannelById(this.plugin.getSettings().getDiscord().getBot().getReportsChannelId());
        if (channel == null) {
            return;
        }
        channel.deleteMessageById(msgId).queue(success -> this.plugin.runSync(task -> {
            Player randomPlayer = this.plugin.getUsersManager().getRandomPlayer();
            report.setDiscordMessageId(null);
            this.plugin.runAsync(task1 -> this.plugin.getReportsManager().updateReportData(randomPlayer, report));
        }));
    }

    public List<Button> getReportButtons(@NotNull Report report) {
        return List.of(Button.primary((String)("waiting:" + report.getId()), (String)"Set as Waiting").withDisabled(report.getStatus().equals((Object)Report.Status.WAITING)).withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\udfe0")), Button.primary((String)("progress:" + report.getId()), (String)"Set as in Progress").withDisabled(report.getStatus().equals((Object)Report.Status.IN_PROGRESS)).withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\udfe1")), Button.success((String)("done:" + report.getId()), (String)"Set as DONE").withDisabled(report.getStatus().equals((Object)Report.Status.DONE)).withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\udfe2")), Button.secondary((String)("archive:" + report.getId()), (String)"Archive").withDisabled(report.getStatus().equals((Object)Report.Status.ARCHIVED)).withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\udcc2")), Button.danger((String)("delete:" + report.getId()), (String)"Delete").withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\uddd1\ufe0f")));
    }

    public MessageEmbed getReportEmbed(@NotNull Report report) {
        if (this.plugin.getDiscordConfig() == null) {
            this.plugin.log(Level.WARNING, "Discord Config is null!", new Throwable[0]);
            throw new IllegalStateException("Discord Config is null!");
        }
        Discord.ReportEmbed config = this.plugin.getDiscordConfig().getReportEmbed();
        String reporterName = report.getReporterName();
        String reportedName = report.getReportedName();
        String reason = report.getReason();
        int id = report.getId();
        int comments = report.getComments().size();
        EmbedBuilder builder = new EmbedBuilder();
        builder.setTitle(this.format(config.getTitle(), id, reporterName, reportedName, reason, comments));
        builder.setColor(config.getColor());
        builder.setTimestamp((TemporalAccessor)Instant.now());
        builder.setAuthor(this.format(config.getAuthor().getName(), id, reporterName, reportedName, reason, comments), null, config.getAuthor().getIcon());
        for (Discord.ReportEmbed.Field f : config.getFields()) {
            builder.addField(this.format(f.getName(), id, reporterName, reportedName, reason, comments), this.format(f.getValue(), id, reporterName, reportedName, reason, comments), f.isInline());
        }
        builder.setFooter(this.format(config.getFooter().getText(), id, reporterName, reportedName, reason, comments), config.getFooter().getIcon());
        return builder.build();
    }

    private String format(String text, int id, String reporter, String reported, String reason, int comments) {
        if (text == null) {
            return null;
        }
        return text.replace("%ID%", String.valueOf(id)).replace("%REPORTER%", reporter != null ? reporter : "Unknown").replace("%REPORTED%", reported != null ? reported : "Unknown").replace("%COMMENTS_COUNT%", String.valueOf(comments)).replace("%REASON%", reason != null ? reason : "No Reason");
    }

    public void sendCommentEmbed(@NotNull Report report, @NotNull Comment comment) {
        if (this.plugin.getDiscordBot().isEmpty() || !this.plugin.getSettings().getDiscord().getBot().isSendNewComments()) {
            return;
        }
        String channelId = this.plugin.getSettings().getDiscord().getBot().getCommentsChannelId();
        if (channelId == null || channelId.isEmpty()) {
            this.plugin.log(Level.WARNING, "Discord Log Channel ID is empty, cannot send Embed.", new Throwable[0]);
            return;
        }
        TextChannel channel = this.plugin.getDiscordBot().get().getJda().getTextChannelById(channelId);
        if (channel == null) {
            this.plugin.log(Level.WARNING, "Discord Log Channel not found! Check the ID: " + channelId, new Throwable[0]);
            return;
        }
        ((MessageCreateAction)channel.sendMessageEmbeds(this.getCommentsEmbed(report, comment), new MessageEmbed[0]).addComponents(new MessageTopLevelComponent[]{ActionRow.of(this.getCommentsButtons(report, comment))})).queue(message -> this.plugin.runSync(task -> {
            Player randomPlayer = this.plugin.getUsersManager().getRandomPlayer();
            comment.setDiscordMessageId(message.getId());
            report.addOrUpdateComment(comment);
            this.plugin.runAsync(task1 -> this.plugin.getReportsManager().updateReportData(randomPlayer, report));
        }));
    }

    public MessageEmbed getCommentsEmbed(@NotNull Report report, @NotNull Comment comment) {
        if (this.plugin.getDiscordConfig() == null) {
            this.plugin.log(Level.WARNING, "Discord Config is null!", new Throwable[0]);
            throw new IllegalStateException("Discord Config is null!");
        }
        Discord.CommentsEmbed config = this.plugin.getDiscordConfig().getCommentsEmbed();
        EmbedBuilder builder = new EmbedBuilder();
        builder.setTitle(config.getTitle().replace("%ID%", String.valueOf(report.getId())));
        builder.setColor(config.getColor());
        builder.setTimestamp((TemporalAccessor)Instant.now());
        builder.setAuthor(config.getAuthor().getName(), null, config.getAuthor().getIcon());
        for (Discord.CommentsEmbed.Field f : config.getFields()) {
            builder.addField(f.getName(), f.getValue().replace("%AUTHOR%", comment.getAuthorName()).replace("%STATUS%", this.plugin.getMessages().getGeneral().getCommentsStatus().get((Object)comment.getStatus())).replace("%COMMENT%", comment.getMessage()), f.isInline());
        }
        builder.setFooter(config.getFooter().getText(), config.getFooter().getIcon());
        return builder.build();
    }

    public List<Button> getCommentsButtons(@NotNull Report report, @NotNull Comment comment) {
        return List.of(Button.success((String)("read:" + report.getId() + ":" + String.valueOf(comment.getId())), (String)"Mark as READ").withDisabled(comment.getStatus().equals((Object)Comment.MessageStatus.READ)).withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\udfe2")), Button.danger((String)("delete:" + report.getId() + ":" + String.valueOf(comment.getId())), (String)"Delete").withEmoji((Emoji)Emoji.fromUnicode((String)"\ud83d\uddd1\ufe0f")));
    }

    public void updateCommentMessage(@NotNull Report report, @NotNull Comment comment) {
        String msgId = comment.getDiscordMessageId();
        if (msgId == null || this.plugin.getDiscordBot().isEmpty()) {
            return;
        }
        TextChannel channel = this.plugin.getDiscordBot().get().getJda().getTextChannelById(this.plugin.getSettings().getDiscord().getBot().getCommentsChannelId());
        if (channel == null) {
            return;
        }
        channel.retrieveMessageById(msgId).queue(message -> ((MessageEditAction)message.editMessageEmbeds(new MessageEmbed[]{this.getCommentsEmbed(report, comment)}).setComponents(new MessageTopLevelComponent[]{ActionRow.of(this.getCommentsButtons(report, comment))})).queue());
    }
}

