/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.gui;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiPageElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiStateElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.List;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class BaseGui {
    protected final UltimateReports plugin;
    protected final Player player;

    public BaseGui(@NotNull UltimateReports plugin, @NotNull Player player) {
        this.plugin = plugin;
        this.player = player;
    }

    protected abstract void open();

    protected void addCommonElements(InventoryGui gui, OnlinePlayer onlinePlayer) {
        gui.setCloseAction(close -> true);
        gui.addElement(new StaticGuiElement('g', new ItemStack(this.plugin.getGuiConfig().getShared().getFillerItem()), 1, click -> true, " "));
        gui.addElement(new StaticGuiElement('f', new ItemStack(this.plugin.getGuiConfig().getShared().getCloseItem()), 1, click -> {
            click.getGui().close();
            return true;
        }, this.serialize(this.plugin.getGuiConfig().getShared().getClose())));
        gui.addElement(new GuiPageElement('d', new ItemStack(this.plugin.getGuiConfig().getShared().getFirstPageItem()), GuiPageElement.PageAction.FIRST, this.serialize(this.plugin.getGuiConfig().getShared().getFirstPage())));
        gui.addElement(new GuiPageElement('e', new ItemStack(this.plugin.getGuiConfig().getShared().getPrevPageItem()), GuiPageElement.PageAction.PREVIOUS, this.serialize(this.plugin.getGuiConfig().getShared().getPrevPage())));
        gui.addElement(new GuiPageElement('h', new ItemStack(this.plugin.getGuiConfig().getShared().getNextPageItem()), GuiPageElement.PageAction.NEXT, this.serialize(this.plugin.getGuiConfig().getShared().getNextPage())));
        gui.addElement(new GuiPageElement('i', new ItemStack(this.plugin.getGuiConfig().getShared().getLastPageItem()), GuiPageElement.PageAction.LAST, this.serialize(this.plugin.getGuiConfig().getShared().getLastPage())));
        GuiStateElement notificationsStatus = new GuiStateElement('a', new GuiStateElement.State(change -> {
            change.getWhoClicked().sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getNotifications().getNotificationsEnabled(), new String[0]));
            onlinePlayer.getPreferences().setNotifications(true);
            this.plugin.getUsersManager().updatePlayer(onlinePlayer);
        }, "notificationsEnabled", new ItemStack(this.plugin.getGuiConfig().getShared().getNotificationsItem()), this.serialize(this.plugin.getGuiConfig().getShared().getDisableNotification())), new GuiStateElement.State(change -> {
            change.getWhoClicked().sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getNotifications().getNotificationsDisabled(), new String[0]));
            onlinePlayer.getPreferences().setNotifications(false);
            this.plugin.getUsersManager().updatePlayer(onlinePlayer);
        }, "notificationsDisabled", new ItemStack(this.plugin.getGuiConfig().getShared().getNotificationsItem()), this.serialize(this.plugin.getGuiConfig().getShared().getEnableNotification())));
        if (onlinePlayer.getPreferences().isNotifications()) {
            notificationsStatus.setState("notificationsEnabled");
        } else {
            notificationsStatus.setState("notificationsDisabled");
        }
        gui.addElement(notificationsStatus);
    }

    protected String serialize(String text) {
        return LegacyComponentSerializer.legacySection().serialize(MineDown.parse(text, new String[0]));
    }

    protected String[] serialize(List<String> mineDownList) {
        return (String[])mineDownList.stream().map(this::serialize).toArray(String[]::new);
    }

    protected String[] getReportInfo(@NotNull Report report) {
        return (String[])this.plugin.getGuiConfig().getShared().getReportInfo().stream().map(s -> s.replace("%STATUS%", "%" + report.getStatus().name() + "%")).map(s -> s.replace("%ID%", String.valueOf(report.getId()))).map(s -> s.replace("%DATE%", this.plugin.getUtils().formatDate(report.getTimestamp()))).map(s -> s.replace("%REPORTER%", report.getReporterName())).map(s -> s.replace("%REPORTED%", report.getReportedName())).map(s -> s.replace("%REASON%", report.getReason())).map(this::replaceStatus).map(this::serialize).toArray(String[]::new);
    }

    protected String replaceStatus(String text) {
        return text.replace("%ALL%", this.plugin.getMessages().getGeneral().getReportStatus().get((Object)Report.Status.OPEN)).replace("%WAITING%", this.plugin.getMessages().getGeneral().getReportStatus().get((Object)Report.Status.WAITING)).replace("%IN_PROGRESS%", this.plugin.getMessages().getGeneral().getReportStatus().get((Object)Report.Status.IN_PROGRESS)).replace("%DONE%", this.plugin.getMessages().getGeneral().getReportStatus().get((Object)Report.Status.DONE)).replace("%ARCHIVED%", this.plugin.getMessages().getGeneral().getReportStatus().get((Object)Report.Status.ARCHIVED)).replace("%NOT_READ%", this.plugin.getMessages().getGeneral().getCommentsStatus().get((Object)Comment.MessageStatus.NOT_READ)).replace("%READ%", this.plugin.getMessages().getGeneral().getCommentsStatus().get((Object)Comment.MessageStatus.READ));
    }

    protected ItemStack enchanted(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
            item.setItemMeta(meta);
        }
        return item;
    }

    protected ItemStack createPlayerSkull(OfflinePlayer owner) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        if (skullMeta != null) {
            skullMeta.setOwningPlayer(owner);
            skull.setItemMeta((ItemMeta)skullMeta);
        }
        return skull;
    }
}

