/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.gui;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.gui.BaseGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.DynamicGuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElementGroup;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class CommentsGui
extends BaseGui {
    private final Report report;
    private GuiElementGroup group;

    public CommentsGui(@NotNull UltimateReports plugin, @NotNull Player player, @NotNull Report report) {
        super(plugin, player);
        this.report = report;
        this.open();
    }

    @Override
    protected void open() {
        this.plugin.getUsersManager().getPlayer(this.player.getUniqueId()).thenAccept(onlinePlayer -> {
            InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, this.serialize(this.plugin.getGuiConfig().getComments().getTitle().replace("%ID%", String.valueOf(this.report.getId()))), this.plugin.getGuiConfig().getComments().getSetup(), new GuiElement[0]);
            this.addCommonElements(gui, (OnlinePlayer)onlinePlayer);
            this.group = new GuiElementGroup('x', new GuiElement[0]);
            this.addComments();
            gui.addElement(this.group);
            gui.show((HumanEntity)this.player);
        });
    }

    private void addComments() {
        this.group.clearElements();
        this.report.getComments().forEach(comment -> {
            OfflinePlayer author = Bukkit.getOfflinePlayer((UUID)comment.getAuthor());
            this.group.addElement(new DynamicGuiElement('o', viewer -> new StaticGuiElement('o', this.createPlayerSkull(author), click -> {
                if (click.getType().equals((Object)ClickType.LEFT)) {
                    if (comment.getStatus().equals((Object)Comment.MessageStatus.READ)) {
                        return true;
                    }
                    if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                        this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                        return true;
                    }
                    comment.setStatus(Comment.MessageStatus.READ);
                    this.report.addOrUpdateComment((Comment)comment);
                    this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, this.report));
                    this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateCommentMessage(this.report, (Comment)comment));
                    this.plugin.getReportsManager().notifyReporter(this.report, this.plugin.getMessages().getReport().getCommentUpdate());
                    click.getGui().draw();
                    return true;
                }
                if (click.getType().equals((Object)ClickType.RIGHT)) {
                    this.report.removeComment(comment.getId());
                    this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, this.report));
                    this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(this.report));
                    this.addComments();
                    click.getGui().draw();
                    return true;
                }
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getComments().getComment().stream().map(s -> s.replace("%AUTHOR%", comment.getAuthorName())).map(s -> s.replace("%MESSAGE%", comment.getMessage())).map(s -> s.replace("%DATE%", this.plugin.getUtils().formatDate(comment.getTimestamp()))).map(s -> s.replace("%STATUS%", "%" + comment.getStatus().name() + "%")).map(this::replaceStatus).collect(Collectors.toList())))));
        });
    }
}

