/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.gui;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.gui.BaseGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Report;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ProcessGui
extends BaseGui {
    private final Report report;
    private OnlinePlayer reporter;

    public ProcessGui(@NotNull UltimateReports plugin, @NotNull Player player, @NotNull Report report, @NotNull OnlinePlayer reporter) {
        super(plugin, player);
        this.report = report;
        this.reporter = reporter;
        this.open();
    }

    @Override
    protected void open() {
        this.plugin.getUsersManager().getPlayer(this.player.getUniqueId()).thenAccept(onlinePlayer -> {
            InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, this.serialize(this.plugin.getGuiConfig().getProcess().getTitle().replace("%ID%", String.valueOf(this.report.getId()))), this.plugin.getGuiConfig().getProcess().getSetup(), new GuiElement[0]);
            this.addCommonElements(gui, (OnlinePlayer)onlinePlayer);
            gui.addElement(new StaticGuiElement('t', new ItemStack(this.plugin.getGuiConfig().getProcess().getMarkAsTrueMaterial()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                if (this.report.getMarkedAs() != null) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getAlreadyProcessed(), new String[0]));
                    return true;
                }
                this.report.setMarkedAs(Report.MarkedAs.TRUE);
                this.report.setStatus(Report.Status.ARCHIVED);
                this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, this.report));
                this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(this.report));
                if (this.plugin.getSettings().isEnableRewardsSystem()) {
                    this.reporter.getPreferences().setRewardsToClaim(this.reporter.getPreferences().getRewardsToClaim() + 1);
                    this.plugin.getUsersManager().updatePlayer(this.reporter);
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getRewards(), new String[0]));
                }
                click.getGui().close();
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getProcess().getMarkAsTrue())));
            gui.addElement(new StaticGuiElement('y', new ItemStack(this.plugin.getGuiConfig().getProcess().getMarkAsFalseMaterial()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                if (this.report.getMarkedAs() != null) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getAlreadyProcessed(), new String[0]));
                    return true;
                }
                this.plugin.getReportsManager().deleteReport(this.player, this.report);
                click.getGui().close();
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getProcess().getMarkAsFalse())));
            gui.show((HumanEntity)this.player);
        });
    }
}

