/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.gui;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.gui.BaseGui;
import dev.xf3d3.ultimatereports.gui.CommentsGui;
import dev.xf3d3.ultimatereports.gui.ProcessGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.DynamicGuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Position;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ReportGui
extends BaseGui {
    private final int id;

    public ReportGui(@NotNull UltimateReports plugin, @NotNull Player player, int id) {
        super(plugin, player);
        this.id = id;
        this.open();
    }

    @Override
    protected void open() {
        Optional<Report> optionalReport = this.plugin.getReportsManager().getReportById(this.id);
        if (optionalReport.isEmpty()) {
            this.plugin.log(Level.WARNING, "Report with id " + this.id + " not found!", new Throwable[0]);
            return;
        }
        Report report = optionalReport.get();
        CompletableFuture<OnlinePlayer> onlinePlayerFuture = this.plugin.getUsersManager().getPlayer(this.player.getUniqueId());
        CompletableFuture<OnlinePlayer> reporterFuture = this.plugin.getUsersManager().getPlayer(report.getReporter());
        CompletableFuture<OnlinePlayer> reportedFuture = this.plugin.getUsersManager().getPlayer(report.getReported());
        CompletableFuture.allOf(onlinePlayerFuture, reporterFuture, reportedFuture).thenAccept(v -> {
            OnlinePlayer onlinePlayer = (OnlinePlayer)onlinePlayerFuture.join();
            OnlinePlayer reporterPlayer = (OnlinePlayer)reporterFuture.join();
            OnlinePlayer reportedPlayer = (OnlinePlayer)reportedFuture.join();
            InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, this.serialize(this.plugin.getGuiConfig().getReport().getTitle().replace("%ID%", String.valueOf(report.getId()))), this.plugin.getGuiConfig().getReport().getSetup(), new GuiElement[0]);
            this.addCommonElements(gui, onlinePlayer);
            gui.addElement(new DynamicGuiElement('o', viewer -> new StaticGuiElement('o', report.getStatus().equals((Object)Report.Status.WAITING) ? this.enchanted(new ItemStack(this.plugin.getGuiConfig().getReport().getWaitingItem())) : new ItemStack(this.plugin.getGuiConfig().getReport().getWaitingItem()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                report.setStatus(Report.Status.WAITING);
                this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, report));
                this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(report));
                this.plugin.getReportsManager().notifyReporter(report, this.plugin.getMessages().getReport().getStatusUpdate());
                click.getGui().draw();
                return true;
            }, this.serialize(this.replaceStatus(this.plugin.getGuiConfig().getReport().getSetStatus().replace("%STATUS%", "%" + Report.Status.WAITING.name() + "%"))))));
            gui.addElement(new DynamicGuiElement('p', viewer -> new StaticGuiElement('p', report.getStatus().equals((Object)Report.Status.IN_PROGRESS) ? this.enchanted(new ItemStack(this.plugin.getGuiConfig().getReport().getInProgressItem())) : new ItemStack(this.plugin.getGuiConfig().getReport().getInProgressItem()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                report.setStatus(Report.Status.IN_PROGRESS);
                this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, report));
                this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(report));
                this.plugin.getReportsManager().notifyReporter(report, this.plugin.getMessages().getReport().getStatusUpdate());
                click.getGui().draw();
                return true;
            }, this.serialize(this.replaceStatus(this.plugin.getGuiConfig().getReport().getSetStatus().replace("%STATUS%", "%" + Report.Status.IN_PROGRESS.name() + "%"))))));
            gui.addElement(new DynamicGuiElement('q', viewer -> new StaticGuiElement('q', report.getStatus().equals((Object)Report.Status.DONE) ? this.enchanted(new ItemStack(this.plugin.getGuiConfig().getReport().getDoneItem())) : new ItemStack(this.plugin.getGuiConfig().getReport().getDoneItem()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                report.setStatus(Report.Status.DONE);
                this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, report));
                this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(report));
                this.plugin.getReportsManager().notifyReporter(report, this.plugin.getMessages().getReport().getStatusUpdate());
                click.getGui().draw();
                return true;
            }, this.serialize(this.replaceStatus(this.plugin.getGuiConfig().getReport().getSetStatus().replace("%STATUS%", "%" + Report.Status.DONE.name() + "%"))))));
            gui.addElement(new DynamicGuiElement('r', viewer -> new StaticGuiElement('r', report.getStatus().equals((Object)Report.Status.ARCHIVED) ? this.enchanted(new ItemStack(this.plugin.getGuiConfig().getReport().getArchiveItem())) : new ItemStack(this.plugin.getGuiConfig().getReport().getArchiveItem()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                report.setStatus(Report.Status.ARCHIVED);
                this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(this.player, report));
                this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(report));
                this.plugin.getReportsManager().notifyReporter(report, this.plugin.getMessages().getReport().getStatusUpdate());
                click.getGui().draw();
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getArchive()))));
            gui.addElement(new DynamicGuiElement('s', viewer -> new StaticGuiElement('s', new ItemStack(this.plugin.getGuiConfig().getReport().getDeleteItem()), 1, click -> {
                if (click.getType() != ClickType.SHIFT_LEFT) {
                    return true;
                }
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                this.plugin.getReportsManager().deleteReport(this.player, report);
                click.getWhoClicked().sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getReportDeleted(), new String[0]));
                click.getGui().close();
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getDelete()))));
            gui.addElement(new DynamicGuiElement('m', viewer -> new StaticGuiElement('m', new ItemStack(this.plugin.getGuiConfig().getReport().getPunishItem()), 1, click -> {
                long cooldown = reporterPlayer.addCoolDown(this.plugin, this.plugin.getSettings().getGeneral().getDefaultCooldown());
                click.getWhoClicked().sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getCooldown().getCooldownAdd().replace("%COOLDOWN%", this.plugin.getUtils().formatTime(cooldown - System.currentTimeMillis())).replace("%PLAYER%", reporterPlayer.getLastPlayerName()), new String[0]));
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getPunishReporter()))));
            OfflinePlayer reporterOfflinePlayer = Bukkit.getOfflinePlayer((UUID)report.getReporter());
            OfflinePlayer reportedOfflinePlayer = Bukkit.getOfflinePlayer((UUID)report.getReported());
            gui.addElement(new StaticGuiElement('l', this.createPlayerSkull(reporterOfflinePlayer), 1, click -> {
                if (!this.player.hasPermission("ultimatereports.reports.teleport")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                if (click.getType().isLeftClick()) {
                    Player reportedOnlinePlayer = Bukkit.getPlayer((UUID)report.getReporter());
                    if (reportedOnlinePlayer == null) {
                        this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getCantTpPlayerOffline(), new String[0]));
                        return true;
                    }
                    this.plugin.getUtils().teleport(this.player, Position.at(reportedOnlinePlayer.getLocation(), this.plugin.getSettings().getCrossServer().getServerName()));
                }
                if (click.getType().isRightClick()) {
                    this.plugin.getUtils().teleport(this.player, report.getReporterPosition());
                }
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getPlayerStats().stream().map(s -> s.replace("%SENT%", String.valueOf(reporterPlayer.getPreferences().getReports()))).map(s -> s.replace("%RECEIVED%", String.valueOf(reporterPlayer.getPreferences().getReported()))).collect(Collectors.toList()))));
            gui.addElement(new StaticGuiElement('n', this.createPlayerSkull(reportedOfflinePlayer), 1, click -> {
                if (!this.player.hasPermission("ultimatereports.reports.teleport")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                if (click.getType().isLeftClick()) {
                    Player reporterOnlinePlayer = Bukkit.getPlayer((UUID)report.getReported());
                    if (reporterOnlinePlayer == null) {
                        this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getCantTpPlayerOffline(), new String[0]));
                        return true;
                    }
                    this.plugin.getUtils().teleport(this.player, Position.at(reporterOnlinePlayer.getLocation(), this.plugin.getSettings().getCrossServer().getServerName()));
                }
                if (click.getType().isRightClick()) {
                    if (report.getReportedPosition() == null) {
                        this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getPositionDoesntExist(), new String[0]));
                        return true;
                    }
                    this.plugin.getUtils().teleport(this.player, report.getReportedPosition());
                }
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getPlayerStats().stream().map(s -> s.replace("%SENT%", String.valueOf(reportedPlayer.getPreferences().getReports()))).map(s -> s.replace("%RECEIVED%", String.valueOf(reportedPlayer.getPreferences().getReported()))).collect(Collectors.toList()))));
            gui.addElement(new StaticGuiElement('t', new ItemStack(this.plugin.getGuiConfig().getReport().getCommentsItem()), 1, click -> {
                new CommentsGui(this.plugin, this.player, report);
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getComments().stream().map(s -> s.replace("%COMMENTS_NUMBER%", String.valueOf(report.getComments().size()))).collect(Collectors.toList()))));
            gui.addElement(new StaticGuiElement('z', new ItemStack(this.plugin.getGuiConfig().getReport().getProcessItem()), 1, click -> {
                if (!click.getWhoClicked().hasPermission("ultimatereports.reports.manage")) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getGeneral().getNoPermission(), new String[0]));
                    return true;
                }
                if (report.getMarkedAs() != null) {
                    this.player.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + this.plugin.getMessages().getReport().getAlreadyProcessed(), new String[0]));
                    return true;
                }
                new ProcessGui(this.plugin, this.player, report, reporterPlayer);
                return true;
            }, this.serialize(this.plugin.getGuiConfig().getReport().getProcessReport())));
            gui.addElement(new StaticGuiElement('u', new ItemStack(Material.PAPER), 1, click -> true, this.getReportInfo(report)));
            gui.show((HumanEntity)this.player);
        });
    }
}

