/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.gui;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.gui.BaseGui;
import dev.xf3d3.ultimatereports.gui.ReportGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElementGroup;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiStateElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Report;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class ReportsList
extends BaseGui {
    private final Report.Status type;
    private final Set<Report> reports;

    public ReportsList(@NotNull UltimateReports plugin, @NotNull Player player, @NotNull Set<Report> reports, @NotNull Report.Status type) {
        super(plugin, player);
        this.reports = reports;
        this.type = type;
        this.open();
    }

    @Override
    protected void open() {
        OnlinePlayer onlinePlayer = this.plugin.getUsersManager().getUsermap().get(this.player.getUniqueId());
        if (onlinePlayer == null) {
            this.plugin.log(Level.WARNING, "Player with UUID " + String.valueOf(this.player.getUniqueId()) + " not found!", new Throwable[0]);
            return;
        }
        String title = this.player.hasPermission("ultimatereports.managereports") ? this.plugin.getGuiConfig().getReportsList().getTitleAllReports() : this.plugin.getGuiConfig().getReportsList().getTitleYourReports();
        InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, this.serialize(title), this.plugin.getGuiConfig().getReportsList().getSetup(), new GuiElement[0]);
        this.addCommonElements(gui, onlinePlayer);
        GuiElementGroup group = new GuiElementGroup('c', new GuiElement[0]);
        this.reports.forEach(report -> {
            OfflinePlayer reporter = Bukkit.getOfflinePlayer((UUID)report.getReporter());
            group.addElement(new StaticGuiElement('o', this.createPlayerSkull(reporter), click -> {
                new ReportGui(this.plugin, this.player, report.getId());
                return true;
            }, this.getReportInfo((Report)report)));
        });
        gui.addElement(group);
        GuiStateElement reportsType = new GuiStateElement('b', new GuiStateElement.State(change -> new ReportsList(this.plugin, this.player, this.plugin.getReportsManager().getWaitingReports(), Report.Status.WAITING), "waiting", new ItemStack(this.plugin.getGuiConfig().getReportsList().getFiltersItem()), this.serialize(this.plugin.getGuiConfig().getReportsList().getFilters().stream().map(s -> s.replace("%FILTER%", "%IN_PROGRESS%")).map(this::replaceStatus).collect(Collectors.toList()))), new GuiStateElement.State(change -> new ReportsList(this.plugin, this.player, this.plugin.getReportsManager().getInProgressReports(), Report.Status.IN_PROGRESS), "in_progress", new ItemStack(this.plugin.getGuiConfig().getReportsList().getFiltersItem()), this.serialize(this.plugin.getGuiConfig().getReportsList().getFilters().stream().map(s -> s.replace("%FILTER%", "%DONE%")).map(this::replaceStatus).collect(Collectors.toList()))), new GuiStateElement.State(change -> new ReportsList(this.plugin, this.player, this.plugin.getReportsManager().getClosedReports(), Report.Status.DONE), "done", new ItemStack(this.plugin.getGuiConfig().getReportsList().getFiltersItem()), this.serialize(this.plugin.getGuiConfig().getReportsList().getFilters().stream().map(s -> s.replace("%FILTER%", "%ARCHIVED%")).map(this::replaceStatus).collect(Collectors.toList()))), new GuiStateElement.State(change -> new ReportsList(this.plugin, this.player, this.plugin.getReportsManager().getArchivedReports(), Report.Status.ARCHIVED), "archived", new ItemStack(this.plugin.getGuiConfig().getReportsList().getFiltersItem()), this.serialize(this.plugin.getGuiConfig().getReportsList().getFilters().stream().map(s -> s.replace("%FILTER%", "%ALL%")).map(this::replaceStatus).collect(Collectors.toList()))), new GuiStateElement.State(change -> new ReportsList(this.plugin, this.player, this.plugin.getReportsManager().getAllReports(), Report.Status.OPEN), "all", new ItemStack(this.plugin.getGuiConfig().getReportsList().getFiltersItem()), this.serialize(this.plugin.getGuiConfig().getReportsList().getFilters().stream().map(s -> s.replace("%FILTER%", "%WAITING%")).map(this::replaceStatus).collect(Collectors.toList()))));
        if (this.type.equals((Object)Report.Status.OPEN)) {
            reportsType.setState("all");
        } else if (this.type.equals((Object)Report.Status.WAITING)) {
            reportsType.setState("waiting");
        } else if (this.type.equals((Object)Report.Status.IN_PROGRESS)) {
            reportsType.setState("in_progress");
        } else if (this.type.equals((Object)Report.Status.DONE)) {
            reportsType.setState("done");
        } else if (this.type.equals((Object)Report.Status.ARCHIVED)) {
            reportsType.setState("archived");
        }
        if (this.player.hasPermission("ultimatereports.reports.manage")) {
            gui.addElement(reportsType);
        }
        gui.show((HumanEntity)this.player);
    }
}

