/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.gui;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.gui.BaseGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import dev.xf3d3.ultimatereports.libraries.inventorygui.StaticGuiElement;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class RewardsGui
extends BaseGui {
    private final OnlinePlayer reporter;
    private boolean hasClaimedItem;

    public RewardsGui(@NotNull UltimateReports plugin, @NotNull Player player, @NotNull OnlinePlayer reporter) {
        super(plugin, player);
        this.reporter = reporter;
        this.open();
    }

    @Override
    protected void open() {
        this.plugin.getUsersManager().getPlayer(this.player.getUniqueId()).thenAccept(onlinePlayer -> {
            InventoryGui gui = new InventoryGui((Plugin)this.plugin, (InventoryHolder)this.player, this.serialize(this.plugin.getGuiConfig().getReward().getTitle()), this.plugin.getGuiConfig().getReward().getSetup(), new GuiElement[0]);
            this.addCommonElements(gui, (OnlinePlayer)onlinePlayer);
            gui.addElement(new StaticGuiElement('a', this.plugin.getRewardsConfig().getRewardItem().toItemStack(), this.plugin.getRewardsConfig().getRewardItem().getAmount(), click -> {
                this.reporter.getPreferences().setRewardsToClaim(this.reporter.getPreferences().getRewardsToClaim() - 1);
                this.plugin.getUsersManager().updatePlayer(this.reporter);
                this.hasClaimedItem = true;
                return false;
            }, ""));
            gui.setCloseAction(close -> {
                if (!this.hasClaimedItem) {
                    this.reporter.getPreferences().setRewardsToClaim(this.reporter.getPreferences().getRewardsToClaim() - 1);
                    this.plugin.getUsersManager().updatePlayer(this.reporter);
                    this.player.give(new ItemStack[]{this.plugin.getRewardsConfig().getRewardItem().toItemStack()});
                }
                this.plugin.getRewardsConfig().getRewardCommands().forEach(command -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command.replace("%PLAYER%", this.player.getName())));
                return false;
            });
            gui.show((HumanEntity)this.player);
        });
    }
}

