/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.libraries.aikar.commands;

import dev.xf3d3.ultimatereports.libraries.aikar.commands.ACFPatterns;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.ACFUtil;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.Annotations;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.BaseCommand;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandCompletions;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandExecutionContext;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandHelp;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandIssuer;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandManager;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandOperationContext;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.CommandParameter;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.InvalidCommandArgument;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.LogLevel;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.MessageKeys;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.MessageType;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.ShowCommandHelp;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandAlias;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandCompletion;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.CommandPermission;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Conditions;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Description;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.HelpSearchTags;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Private;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.annotation.Syntax;
import dev.xf3d3.ultimatereports.libraries.aikar.commands.contexts.ContextResolver;
import dev.xf3d3.ultimatereports.libraries.aikar.locales.MessageKeyProvider;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;

public class RegisteredCommand<CEC extends CommandExecutionContext<CEC, ? extends CommandIssuer>> {
    final BaseCommand scope;
    final Method method;
    final CommandParameter<CEC>[] parameters;
    final CommandManager manager;
    final List<String> registeredSubcommands = new ArrayList<String>();
    String command;
    String prefSubCommand;
    String syntaxText;
    String helpText;
    String permission;
    String complete;
    String conditions;
    public String helpSearchTags;
    boolean isPrivate;
    final int requiredResolvers;
    final int consumeInputResolvers;
    final int doesNotConsumeInputResolvers;
    final int optionalResolvers;
    final Set<String> permissions = new HashSet<String>();

    RegisteredCommand(BaseCommand scope, String command, Method method, String prefSubCommand) {
        this.scope = scope;
        this.manager = this.scope.manager;
        Annotations annotations = this.manager.getAnnotations();
        if (BaseCommand.isSpecialSubcommand(prefSubCommand)) {
            prefSubCommand = "";
            command = command.trim();
        }
        this.command = command + (!annotations.hasAnnotation(method, CommandAlias.class, false) && !prefSubCommand.isEmpty() ? prefSubCommand : "");
        this.method = method;
        this.prefSubCommand = prefSubCommand;
        this.permission = annotations.getAnnotationValue(method, CommandPermission.class, 9);
        this.complete = annotations.getAnnotationValue(method, CommandCompletion.class, 17);
        this.helpText = annotations.getAnnotationValue(method, Description.class, 17);
        this.conditions = annotations.getAnnotationValue(method, Conditions.class, 9);
        this.helpSearchTags = annotations.getAnnotationValue(method, HelpSearchTags.class, 9);
        this.syntaxText = annotations.getAnnotationValue(method, Syntax.class, 1);
        Parameter[] parameters = method.getParameters();
        this.parameters = new CommandParameter[parameters.length];
        this.isPrivate = annotations.hasAnnotation(method, Private.class) || annotations.getAnnotationFromClass(scope.getClass(), Private.class) != null;
        int requiredResolvers = 0;
        int consumeInputResolvers = 0;
        int doesNotConsumeInputResolvers = 0;
        int optionalResolvers = 0;
        CommandParameter previousParam = null;
        for (int i = 0; i < parameters.length; ++i) {
            this.parameters[i] = new CommandParameter(this, parameters[i], i, i == parameters.length - 1);
            CommandParameter parameter = this.parameters[i];
            if (previousParam != null) {
                previousParam.setNextParam(parameter);
            }
            previousParam = parameter;
            if (parameter.isCommandIssuer()) continue;
            if (!parameter.requiresInput()) {
                ++optionalResolvers;
            } else {
                ++requiredResolvers;
            }
            if (parameter.canConsumeInput()) {
                ++consumeInputResolvers;
                continue;
            }
            ++doesNotConsumeInputResolvers;
        }
        this.requiredResolvers = requiredResolvers;
        this.consumeInputResolvers = consumeInputResolvers;
        this.doesNotConsumeInputResolvers = doesNotConsumeInputResolvers;
        this.optionalResolvers = optionalResolvers;
        this.computePermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invoke(CommandIssuer sender, List<String> args, CommandOperationContext context) {
        if (!this.scope.canExecute(sender, this)) {
            return;
        }
        this.preCommand();
        try {
            this.manager.getCommandConditions().validateConditions(context);
            Map<String, Object> passedArgs = this.resolveContexts(sender, args);
            if (passedArgs == null) {
                return;
            }
            Object obj = this.method.invoke((Object)this.scope, passedArgs.values().toArray());
            if (obj instanceof CompletionStage) {
                CompletionStage future = (CompletionStage)obj;
                future.exceptionally(t -> {
                    this.handleException(sender, args, (Throwable)t);
                    return null;
                });
            }
        }
        catch (Exception e) {
            this.handleException(sender, args, e);
        }
        finally {
            this.postCommand();
        }
    }

    public void preCommand() {
    }

    public void postCommand() {
    }

    void handleException(CommandIssuer sender, List<String> args, Throwable e) {
        while (e instanceof ExecutionException || e instanceof CompletionException || e instanceof InvocationTargetException) {
            e = e.getCause();
        }
        if (e instanceof ShowCommandHelp) {
            ShowCommandHelp showHelp = (ShowCommandHelp)e;
            CommandHelp commandHelp = this.manager.generateCommandHelp();
            if (showHelp.search) {
                commandHelp.setSearch(showHelp.searchArgs == null ? args : showHelp.searchArgs);
            }
            commandHelp.showHelp(sender);
        } else if (e instanceof InvalidCommandArgument) {
            InvalidCommandArgument invalidCommandArg = (InvalidCommandArgument)e;
            if (invalidCommandArg.key != null) {
                sender.sendMessage(MessageType.ERROR, invalidCommandArg.key, invalidCommandArg.replacements);
            } else if (e.getMessage() != null && !e.getMessage().isEmpty()) {
                sender.sendMessage(MessageType.ERROR, MessageKeys.ERROR_PREFIX, "{message}", e.getMessage());
            }
            if (invalidCommandArg.showSyntax) {
                this.scope.showSyntax(sender, this);
            }
        } else {
            try {
                boolean hasExceptionHandler;
                if (!this.manager.handleUncaughtException(this.scope, this, sender, args, e)) {
                    sender.sendMessage(MessageType.ERROR, MessageKeys.ERROR_PERFORMING_COMMAND, new String[0]);
                }
                boolean bl = hasExceptionHandler = this.manager.defaultExceptionHandler != null || this.scope.getExceptionHandler() != null;
                if (!hasExceptionHandler || this.manager.logUnhandledExceptions) {
                    this.manager.log(LogLevel.ERROR, "Exception in command: " + this.command + " " + ACFUtil.join(args), e);
                }
            }
            catch (Exception e2) {
                this.manager.log(LogLevel.ERROR, "Exception in handleException for command: " + this.command + " " + ACFUtil.join(args), e);
                this.manager.log(LogLevel.ERROR, "Exception triggered by exception handler:", e2);
            }
        }
    }

    @Nullable
    Map<String, Object> resolveContexts(CommandIssuer sender, List<String> args) throws InvalidCommandArgument {
        return this.resolveContexts(sender, args, null);
    }

    @Nullable
    Map<String, Object> resolveContexts(CommandIssuer sender, List<String> args, String name) throws InvalidCommandArgument {
        args = new ArrayList<String>(args);
        String[] origArgs = args.toArray(new String[args.size()]);
        LinkedHashMap<String, Object> passedArgs = new LinkedHashMap<String, Object>();
        int remainingRequired = this.requiredResolvers;
        CommandOperationContext opContext = CommandManager.getCurrentCommandOperationContext();
        for (int i = 0; !(i >= this.parameters.length || name != null && passedArgs.containsKey(name)); ++i) {
            boolean isLast = i == this.parameters.length - 1;
            boolean allowOptional = remainingRequired == 0;
            CommandParameter<CEC> parameter = this.parameters[i];
            String parameterName = parameter.getName();
            Class<?> type = parameter.getType();
            ContextResolver<?, CEC> resolver = parameter.getResolver();
            CommandExecutionContext context = this.manager.createCommandContext(this, parameter, sender, args, i, passedArgs);
            boolean requiresInput = parameter.requiresInput();
            if (requiresInput && remainingRequired > 0) {
                --remainingRequired;
            }
            Set<String> parameterPermissions = parameter.getRequiredPermissions();
            if (args.isEmpty() && (!isLast || type != String[].class)) {
                if (allowOptional && parameter.getDefaultValue() != null) {
                    args.add(parameter.getDefaultValue());
                } else {
                    if (allowOptional && parameter.isOptional()) {
                        Object value = !parameter.isOptionalResolver() || !this.manager.hasPermission(sender, parameterPermissions) ? null : (Object)resolver.getContext(context);
                        if (value == null && parameter.getClass().isPrimitive()) {
                            throw new IllegalStateException("Parameter " + parameter.getName() + " is primitive and does not support Optional.");
                        }
                        this.manager.getCommandConditions().validateConditions(context, value);
                        passedArgs.put(parameterName, value);
                        continue;
                    }
                    if (requiresInput) {
                        this.scope.showSyntax(sender, this);
                        return null;
                    }
                }
            } else if (!this.manager.hasPermission(sender, parameterPermissions)) {
                sender.sendMessage(MessageType.ERROR, MessageKeys.PERMISSION_DENIED_PARAMETER, "{param}", parameterName);
                throw new InvalidCommandArgument(false);
            }
            if (parameter.getValues() != null) {
                String arg = !args.isEmpty() ? args.get(0) : "";
                HashSet<String> possible = new HashSet<String>();
                CommandCompletions<?> commandCompletions = this.manager.getCommandCompletions();
                for (String s : parameter.getValues()) {
                    List<String> check;
                    if ("*".equals(s) || "@completions".equals(s)) {
                        s = commandCompletions.findDefaultCompletion(this, origArgs);
                    }
                    if (!(check = commandCompletions.getCompletionValues(this, sender, s, origArgs, opContext.isAsync())).isEmpty()) {
                        possible.addAll(check.stream().filter(Objects::nonNull).map(String::toLowerCase).collect(Collectors.toList()));
                        continue;
                    }
                    possible.add(s.toLowerCase(Locale.ENGLISH));
                }
                if (!possible.contains(arg.toLowerCase(Locale.ENGLISH))) {
                    throw new InvalidCommandArgument((MessageKeyProvider)MessageKeys.PLEASE_SPECIFY_ONE_OF, "{valid}", ACFUtil.join(possible, ", "));
                }
            }
            Object paramValue = resolver.getContext(context);
            this.manager.getCommandConditions().validateConditions(context, paramValue);
            passedArgs.put(parameterName, paramValue);
        }
        return passedArgs;
    }

    boolean hasPermission(CommandIssuer issuer) {
        return this.manager.hasPermission(issuer, this.getRequiredPermissions());
    }

    @Deprecated
    public String getPermission() {
        if (this.permission == null || this.permission.isEmpty()) {
            return null;
        }
        return ACFPatterns.COMMA.split(this.permission)[0];
    }

    void computePermissions() {
        this.permissions.clear();
        this.permissions.addAll(this.scope.getRequiredPermissions());
        if (this.permission != null && !this.permission.isEmpty()) {
            this.permissions.addAll(Arrays.asList(ACFPatterns.COMMA.split(this.permission)));
        }
    }

    public Set<String> getRequiredPermissions() {
        return this.permissions;
    }

    public boolean requiresPermission(String permission) {
        return this.getRequiredPermissions().contains(permission);
    }

    public String getPrefSubCommand() {
        return this.prefSubCommand;
    }

    public String getSyntaxText() {
        return this.getSyntaxText(null);
    }

    public String getSyntaxText(CommandIssuer issuer) {
        if (this.syntaxText != null) {
            return this.syntaxText;
        }
        StringBuilder syntaxBuilder = new StringBuilder(64);
        for (CommandParameter<CEC> parameter : this.parameters) {
            String syntax = parameter.getSyntax(issuer);
            if (syntax == null) continue;
            if (syntaxBuilder.length() > 0) {
                syntaxBuilder.append(' ');
            }
            syntaxBuilder.append(syntax);
        }
        return syntaxBuilder.toString().trim();
    }

    public String getHelpText() {
        return this.helpText != null ? this.helpText : "";
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public String getCommand() {
        return this.command;
    }

    public void addSubcommand(String cmd) {
        this.registeredSubcommands.add(cmd);
    }

    public void addSubcommands(Collection<String> cmd) {
        this.registeredSubcommands.addAll(cmd);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotation) {
        return this.method.getAnnotation(annotation);
    }
}

