/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.libraries.configlib;

import dev.xf3d3.ultimatereports.libraries.configlib.ConfigurationElement;
import dev.xf3d3.ultimatereports.libraries.configlib.PostProcess;
import dev.xf3d3.ultimatereports.libraries.configlib.Validator;
import java.util.function.Predicate;

public interface ConfigurationElementFilter
extends Predicate<ConfigurationElement<?>> {
    default public ConfigurationElementFilter and(Predicate<? super ConfigurationElement<?>> other) {
        return element -> this.test(element) && other.test((ConfigurationElement<?>)element);
    }

    public static ConfigurationElementFilter byType(Class<?> type) {
        Validator.requireNonNull(type, "type");
        return element -> element.type().equals(type);
    }

    public static ConfigurationElementFilter byPostProcessKey(String key) {
        Validator.requireNonNull(key, "post-process key");
        return element -> {
            PostProcess postProcess = element.annotation(PostProcess.class);
            if (postProcess == null) {
                return false;
            }
            String actualKey = postProcess.key();
            return actualKey.equals(key);
        };
    }
}

