/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.libraries.inventorygui;

import dev.xf3d3.ultimatereports.libraries.inventorygui.GuiElement;
import dev.xf3d3.ultimatereports.libraries.inventorygui.InventoryGui;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.ItemStack;

public class GuiStateElement
extends GuiElement {
    private Supplier<Integer> queryState = null;
    private boolean silent = false;
    private int currentState;
    private final State[] states;
    private boolean switchStateOnClick;

    public GuiStateElement(char slotChar, boolean switchStateOnClick, int defaultState, State ... states) {
        super(slotChar, null);
        if (states.length == 0) {
            throw new IllegalArgumentException("You need to add at least one State!");
        }
        this.switchStateOnClick = switchStateOnClick;
        this.currentState = defaultState;
        this.states = states;
        this.setAction(click -> {
            if (this.switchStateOnClick) {
                this.getState().change.onLeave(click);
            }
            State next = this.switchStateOnClick ? this.nextState() : this.getState();
            next.change.onChange(click);
            if (!this.isSilent()) {
                click.getGui().playClickSound();
            }
            this.gui.draw(click.getWhoClicked(), false);
            return true;
        });
    }

    public GuiStateElement(char slotChar, int defaultState, State ... states) {
        this(slotChar, true, defaultState, states);
    }

    public GuiStateElement(char slotChar, boolean switchStateOnClick, String defaultState, State ... states) {
        this(slotChar, switchStateOnClick, GuiStateElement.getStateIndex(defaultState, states), states);
    }

    public GuiStateElement(char slotChar, String defaultState, State ... states) {
        this(slotChar, true, defaultState, states);
    }

    public GuiStateElement(char slotChar, boolean switchStateOnClick, Supplier<String> queryState, State ... states) {
        this(slotChar, switchStateOnClick, queryState.get(), states);
        this.queryState = () -> GuiStateElement.getStateIndex((String)queryState.get(), states);
    }

    public GuiStateElement(char slotChar, Supplier<String> queryState, State ... states) {
        this(slotChar, true, queryState, states);
    }

    public GuiStateElement(char slotChar, boolean switchStateOnClick, State ... states) {
        this(slotChar, switchStateOnClick, 0, states);
    }

    public GuiStateElement(char slotChar, State ... states) {
        this(slotChar, true, states);
    }

    public State nextState() {
        this.queryCurrentState();
        this.currentState = this.states.length > this.currentState + 1 ? this.currentState + 1 : 0;
        return this.states[this.currentState];
    }

    public State previousState() {
        this.queryCurrentState();
        this.currentState = this.currentState > 0 ? this.currentState - 1 : this.states.length - 1;
        return this.states[this.currentState];
    }

    @Override
    public ItemStack getItem(HumanEntity who, int slot) {
        return this.getState().getItem(who);
    }

    @Override
    public void setGui(InventoryGui gui) {
        super.setGui(gui);
        for (State state : this.states) {
            state.setGui(gui);
        }
    }

    public State getState() {
        this.queryCurrentState();
        return this.states[this.currentState];
    }

    public boolean isSilent() {
        return this.silent;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean shouldSwitchStateOnClick() {
        return this.switchStateOnClick;
    }

    public void setSwitchStateOnClick(boolean switchStateOnClick) {
        this.switchStateOnClick = switchStateOnClick;
    }

    private void queryCurrentState() {
        if (this.queryState != null) {
            this.currentState = this.queryState.get();
        }
    }

    public void setState(String key) throws IllegalArgumentException {
        this.currentState = GuiStateElement.getStateIndex(key, this.states);
    }

    private static int getStateIndex(String key, State[] states) throws IllegalArgumentException {
        for (int i = 0; i < states.length; ++i) {
            if (!states[i].getKey().equals(key)) continue;
            return i;
        }
        throw new IllegalArgumentException("This element does not have the state " + key);
    }

    public static class State {
        private final Change change;
        private final String key;
        private final ItemStack item;
        private String[] text;
        private InventoryGui gui;

        public State(Change change, String key, ItemStack item, String ... text) {
            this.change = change;
            this.key = key;
            this.item = item;
            this.text = text;
        }

        public void setText(String ... text) {
            this.text = text;
        }

        @Deprecated
        public ItemStack getItem() {
            return this.getItem(null);
        }

        public ItemStack getItem(HumanEntity who) {
            ItemStack clone = this.item.clone();
            this.gui.setItemText(who, clone, this.getText());
            return clone;
        }

        public String getKey() {
            return this.key;
        }

        public String[] getText() {
            return this.text;
        }

        private void setGui(InventoryGui gui) {
            this.gui = gui;
        }

        public static interface Change {
            public void onChange(GuiElement.Click var1);

            default public void onLeave(GuiElement.Click click) {
            }
        }

        public static class ChangeHandler
        implements Change {
            private final Consumer<GuiElement.Click> onStateEnter;
            private final Consumer<GuiElement.Click> onStateLeave;

            public ChangeHandler(Consumer<GuiElement.Click> onStateEnter, Consumer<GuiElement.Click> onStateLeave) {
                this.onStateEnter = onStateEnter;
                this.onStateLeave = onStateLeave;
            }

            @Override
            public void onChange(GuiElement.Click click) {
                if (this.onStateEnter != null) {
                    this.onStateEnter.accept(click);
                }
            }

            @Override
            public void onLeave(GuiElement.Click click) {
                if (this.onStateLeave != null) {
                    this.onStateLeave.accept(click);
                }
            }
        }
    }
}

