/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.libraries.inventorygui;

import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.ApiStatus;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.WeakHashMap;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;

@ApiStatus.Internal
public class GuiView {
    private static final MethodHandle GET_TOP_INVENTORY = GuiView.unreflect("getTopInventory");
    private static final MethodHandle GET_BOTTOM_INVENTORY = GuiView.unreflect("getBottomInventory");
    private static final MethodHandle GET_PLAYER = GuiView.unreflect("getPlayer");
    private static final MethodHandle GET_TYPE = GuiView.unreflect("getType");
    private static final MethodHandle SET_ITEM = GuiView.unreflect("setItem");
    private static final MethodHandle GET_ITEM = GuiView.unreflect("getItem");
    private static final MethodHandle SET_CURSOR = GuiView.unreflect("setCursor");
    private static final MethodHandle GET_CURSOR = GuiView.unreflect("getCursor");
    private static final MethodHandle GET_INVENTORY = GuiView.unreflect("getInventory");
    private static final MethodHandle CONVERT_SLOT = GuiView.unreflect("convertSlot");
    private static final MethodHandle GET_SLOT_TYPE = GuiView.unreflect("getSlotType");
    private static final MethodHandle CLOSE = GuiView.unreflect("close");
    private static final MethodHandle COUNT_SLOTS = GuiView.unreflect("countSlots");
    private static final MethodHandle SET_PROPERTY = GuiView.unreflect("setProperty");
    private static final MethodHandle GET_TITLE = GuiView.unreflect("getTitle");
    private static final WeakHashMap<InventoryView, GuiView> VIEWS = new WeakHashMap();
    private final InventoryView view;

    public static GuiView of(InventoryView view) {
        return VIEWS.computeIfAbsent(view, k -> new GuiView(view));
    }

    public GuiView(InventoryView view) {
        this.view = view;
    }

    public Inventory getTopInventory() {
        return (Inventory)this.invoke(GET_TOP_INVENTORY);
    }

    public Inventory getBottomInventory() {
        return (Inventory)this.invoke(GET_BOTTOM_INVENTORY);
    }

    public HumanEntity getPlayer() {
        return (HumanEntity)this.invoke(GET_PLAYER);
    }

    public InventoryType getType() {
        return (InventoryType)this.invoke(GET_TYPE);
    }

    public void setItem(int slot, ItemStack item) {
        try {
            SET_ITEM.invoke(this.view, slot, item);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public ItemStack getItem(int slot) {
        return (ItemStack)this.invoke(GET_ITEM, slot);
    }

    public void setCursor(ItemStack item) {
        try {
            SET_CURSOR.invoke(this.view, item);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public ItemStack getCursor() {
        return (ItemStack)this.invoke(GET_CURSOR);
    }

    public Inventory getInventory(int rawSlot) {
        return (Inventory)this.invoke(GET_INVENTORY, rawSlot);
    }

    public int convertSlot(int slot) {
        return (Integer)this.invoke(CONVERT_SLOT, slot);
    }

    public InventoryType.SlotType getSlotType(int slot) {
        return (InventoryType.SlotType)this.invoke(GET_SLOT_TYPE, slot);
    }

    public void close() {
        try {
            CLOSE.invoke(this.view);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public int countSlots() {
        return (Integer)this.invoke(COUNT_SLOTS);
    }

    public boolean setProperty(InventoryView.Property prop, int value) {
        try {
            return SET_PROPERTY.invoke(prop, value);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    public String getTitle() {
        return (String)this.invoke(GET_TITLE);
    }

    private <T> T invoke(MethodHandle method) {
        try {
            return (T)method.invoke(this.view);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private <T> T invoke(MethodHandle method, int slot) {
        try {
            return (T)method.invoke(this.view, slot);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    private static MethodHandle unreflect(String name) {
        for (Method method : InventoryView.class.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            try {
                return MethodHandles.lookup().unreflect(method);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }
}

