/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.listeners;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.User;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class PlayerConnectEvent
implements Listener {
    private final UltimateReports plugin;

    public PlayerConnectEvent(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerJoin(PlayerJoinEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        this.plugin.getUsersManager().getOnlineUserMap().remove(uuid);
        this.plugin.getUsersManager().getOnlineUserMap().put(player.getUniqueId(), player);
        this.plugin.getUsersManager().getPlayer(player.getUniqueId()).thenAccept(onlinePlayer -> {
            if (!player.getName().equals(onlinePlayer.getLastPlayerName())) {
                this.plugin.getUsersManager().updatePlayerName(player);
            }
            onlinePlayer.getPreferences().getTeleportTarget().ifPresent(position -> {
                Location location = new Location(Bukkit.getWorld((String)position.getWorld()), position.getX(), position.getY(), position.getZ(), position.getYaw(), position.getPitch());
                onlinePlayer.getPreferences().clearTeleportTarget();
                this.plugin.getUsersManager().updatePlayer((OnlinePlayer)onlinePlayer);
            });
        });
        this.plugin.runSyncDelayed(() -> this.plugin.getUsersManager().syncGlobalUserList(player, this.plugin.getUsersManager().getOnlineUserMap().values().stream().map(online -> User.of(online.getUniqueId(), online.getName())).toList()), 40L);
    }
}

