/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.listeners;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.User;
import dev.xf3d3.ultimatereports.network.Broker;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerDisconnectEvent
implements Listener {
    private final UltimateReports plugin;

    public PlayerDisconnectEvent(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.plugin.getUsersManager().removePlayer(player.getUniqueId());
        this.plugin.getUsersManager().getOnlineUserMap().remove(player.getUniqueId());
        if (this.plugin.getSettings().getCrossServer().isEnabled()) {
            List<User> localPlayerList = this.plugin.getUsersManager().getOnlineUserMap().values().stream().filter(u -> !u.equals((Object)player)).map(u -> User.of(u.getUniqueId(), u.getName())).toList();
            if (this.plugin.getSettings().getCrossServer().getBrokerType() == Broker.Type.REDIS) {
                this.plugin.getUsersManager().syncGlobalUserList(player, localPlayerList);
            } else {
                this.plugin.getUsersManager().getOnlineUserMap().values().stream().filter(u -> !u.equals((Object)player)).findAny().ifPresent(user -> this.plugin.getUsersManager().syncGlobalUserList((Player)user, localPlayerList));
            }
        }
    }
}

