/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.managers;

import com.google.common.collect.Sets;
import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.libraries.minedown.adventure.MineDown;
import dev.xf3d3.ultimatereports.models.Comment;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Position;
import dev.xf3d3.ultimatereports.models.Report;
import dev.xf3d3.ultimatereports.network.Broker;
import dev.xf3d3.ultimatereports.network.Message;
import dev.xf3d3.ultimatereports.network.Payload;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class ReportsManager {
    private final UltimateReports plugin;
    private final Set<Report> reports = Sets.newConcurrentHashSet();

    public ReportsManager(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    public void loadReports() {
        this.reports.addAll(this.plugin.getDatabase().loadReports());
        this.plugin.sendConsole("&eLoaded " + this.reports.size() + " reports!");
        this.plugin.setLoaded(true);
    }

    public void removeReport(@NotNull Report report) {
        this.reports.removeIf(r -> r.getId() == report.getId());
    }

    public void updateReportLocal(@NotNull Report report) {
        this.removeReport(report);
        this.reports.add(report);
    }

    public void updateReportLocal(Report report, Integer id) {
        this.reports.removeIf(r -> r.getId() == id.intValue());
        this.reports.add(report);
    }

    public void updateReportData(@Nullable Player actor, @NotNull Report report) {
        this.updateReportLocal(report);
        this.plugin.getDatabase().updateReport(report);
        this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.REPORT_UPDATE).payload(Payload.integer(report.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, actor));
    }

    public void deleteReport(@Nullable Player actor, @NotNull Report report) {
        this.plugin.runAsync(task -> {
            this.plugin.getDatabase().deleteReport(report.getId());
            this.removeReport(report);
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.REPORT_DELETE).payload(Payload.integer(report.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, actor));
        });
    }

    public void createReport(@NotNull Player reporter, @NotNull OfflinePlayer reported, @NotNull String reason, @Nullable Player reportedPlayer) {
        this.plugin.runAsync(task -> {
            Position reporterPosition = Position.at(reporter.getX(), reporter.getY(), reporter.getZ(), reporter.getWorld().getName(), reporter.getYaw(), reporter.getPitch(), this.plugin.getSettings().getCrossServer().isEnabled() ? this.plugin.getSettings().getCrossServer().getServerName() : null);
            Position reportedPosition = reportedPlayer != null ? Position.at(reportedPlayer.getX(), reportedPlayer.getY(), reportedPlayer.getZ(), reportedPlayer.getWorld().getName(), reportedPlayer.getYaw(), reportedPlayer.getPitch(), this.plugin.getSettings().getCrossServer().isEnabled() ? this.plugin.getSettings().getCrossServer().getServerName() : null) : null;
            Report report = this.plugin.getDatabase().createReport(reporter, reported, reason, reporterPosition, reportedPosition);
            this.reports.add(report);
            this.plugin.getMessageBroker().ifPresent(broker -> Message.builder().type(Message.Type.REPORT_CREATE).payload(Payload.integer(report.getId())).target("ALL", Message.TargetType.SERVER).build().send((Broker)broker, reporter));
            this.plugin.getWebHookSender().ifPresent(sender -> sender.sendReportEmbed(report));
            this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().sendReportEmbed(report));
            this.plugin.runSync(task1 -> Bukkit.getOnlinePlayers().stream().filter(p -> p.hasPermission("ultimatereports.reports.notify")).forEach(p -> this.plugin.getUsersManager().getPlayer(p.getUniqueId()).thenAccept(u -> {
                if (u.getPreferences().isNotifications()) {
                    p.sendMessage(MineDown.parse(String.join((CharSequence)"\n", this.plugin.getMessages().getReport().getAdminNotification()).replace("%REPORTER%", reporter.getName()).replace("%REPORTED%", Objects.requireNonNullElse(reported.getName(), "Player not found")).replace("%ID%", String.valueOf(report.getId())).replace("%REASON%", report.getReason()), new String[0]));
                }
            })));
        });
        this.plugin.getUsersManager().getPlayer(reporter.getUniqueId()).thenAccept(user -> {
            user.getPreferences().setReports(user.getPreferences().getReports() + 1);
            this.plugin.getUsersManager().updatePlayer((OnlinePlayer)user);
        });
        this.plugin.getUsersManager().getPlayer(reported.getUniqueId()).thenAccept(user -> {
            user.getPreferences().setReported(user.getPreferences().getReported() + 1);
            this.plugin.getUsersManager().updatePlayer((OnlinePlayer)user);
        });
    }

    public void addComment(@NotNull Player author, @NotNull Report report, @NotNull String commentText) {
        Comment comment = Comment.create(author, commentText);
        report.getComments().add(comment);
        this.plugin.runAsync(task -> this.plugin.getReportsManager().updateReportData(author, report));
        this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().updateReportMessage(report));
        this.plugin.getDiscordBot().ifPresent(bot -> bot.getEmbedSender().sendCommentEmbed(report, comment));
        this.plugin.getWebHookSender().ifPresent(sender -> this.plugin.runAsync(task -> sender.sendCommentEmbed(report, comment)));
        if (report.getReporter().equals(author.getUniqueId())) {
            return;
        }
        this.notifyReporter(report, this.plugin.getMessages().getReport().getNewComment());
    }

    public void notifyReporter(@NotNull Report report, @NotNull String msg) {
        Player reporter = Bukkit.getPlayer((UUID)report.getReporter());
        if (reporter == null || !this.plugin.getSettings().getGeneral().isSendNotification()) {
            return;
        }
        this.plugin.getUsersManager().getPlayer(reporter.getUniqueId()).thenAccept(user -> {
            if (!user.getPreferences().isNotifications()) {
                return;
            }
            String message = msg.replace("%ID%", String.valueOf(report.getId())).replace("%STATUS%", this.plugin.getMessages().getGeneral().getReportStatus().get((Object)report.getStatus()));
            reporter.sendMessage(MineDown.parse(this.plugin.getSettings().getGeneral().getPrefix() + message, new String[0]));
        });
    }

    public Optional<Report> getReportById(int id) {
        return this.reports.stream().filter(r -> r.getId() == id).findFirst();
    }

    public Set<Report> getAllReports() {
        return this.getReports().stream().sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Report> getPlayerReports(@NotNull UUID uuid) {
        return this.getReports().stream().filter(report -> report.getReporter().equals(uuid)).sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Report> getOpenReports() {
        return this.getReports().stream().filter(report -> !report.getStatus().equals((Object)Report.Status.ARCHIVED)).sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Report> getWaitingReports() {
        return this.getReports().stream().filter(report -> report.getStatus().equals((Object)Report.Status.WAITING)).sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Report> getInProgressReports() {
        return this.getReports().stream().filter(report -> report.getStatus().equals((Object)Report.Status.IN_PROGRESS)).sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Report> getClosedReports() {
        return this.getReports().stream().filter(report -> report.getStatus().equals((Object)Report.Status.DONE)).sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public Set<Report> getArchivedReports() {
        return this.getReports().stream().filter(report -> report.getStatus().equals((Object)Report.Status.ARCHIVED)).sorted(Comparator.comparingInt(Report::getId)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Generated
    public Set<Report> getReports() {
        return this.reports;
    }
}

