/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.managers;

import com.google.common.collect.Maps;
import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.models.OnlinePlayer;
import dev.xf3d3.ultimatereports.models.Preferences;
import dev.xf3d3.ultimatereports.models.Report;
import dev.xf3d3.ultimatereports.models.User;
import dev.xf3d3.ultimatereports.network.Broker;
import dev.xf3d3.ultimatereports.network.Message;
import dev.xf3d3.ultimatereports.network.Payload;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.stream.Stream;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class UsersManager {
    private final Map<UUID, OnlinePlayer> usermap = Maps.newConcurrentMap();
    private final UltimateReports plugin;
    private final Map<String, List<User>> globalUserList = Maps.newConcurrentMap();
    private final ConcurrentMap<UUID, Player> onlineUserMap = Maps.newConcurrentMap();

    public UsersManager(@NotNull UltimateReports plugin) {
        this.plugin = plugin;
    }

    public Set<UUID> getRawUsermapList() {
        return this.usermap.keySet();
    }

    public List<User> getUserList() {
        return Stream.concat(this.globalUserList.values().stream().flatMap(Collection::stream), this.onlineUserMap.values().stream().map(player -> User.of(player.getUniqueId(), player.getName()))).distinct().sorted().toList();
    }

    public Collection<Player> getOnlineUsers() {
        return this.getOnlineUserMap().values();
    }

    public Optional<Player> findOnlinePlayer(@NotNull String username) {
        return this.onlineUserMap.values().stream().filter(online -> online.getName().equalsIgnoreCase(username)).findFirst();
    }

    public void setUserList(@NotNull String server, @NotNull List<User> players) {
        this.globalUserList.values().forEach(list -> {
            list.removeAll(players);
            list.removeAll(this.onlineUserMap.values().stream().map(player -> User.of(player.getUniqueId(), player.getName())).toList());
        });
        this.globalUserList.put(server, players);
    }

    public void syncGlobalUserList(@NotNull Player user, @NotNull List<User> onlineUsers) {
        Optional<Broker> optionalBroker = this.plugin.getMessageBroker();
        if (optionalBroker.isEmpty()) {
            return;
        }
        Broker broker = optionalBroker.get();
        Message.builder().type(Message.Type.UPDATE_USER_LIST).target("ALL", Message.TargetType.SERVER).payload(Payload.userList(onlineUsers)).build().send(broker, user);
        if (this.onlineUserMap.size() == 1) {
            this.globalUserList.clear();
            Message.builder().type(Message.Type.REQUEST_USER_LIST).target("ALL", Message.TargetType.SERVER).build().send(broker, user);
        }
    }

    public void removePlayer(UUID uuid) {
        this.usermap.remove(uuid);
    }

    public CompletableFuture<OnlinePlayer> getPlayer(UUID uuid) {
        String name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
        if (this.usermap.containsKey(uuid)) {
            return CompletableFuture.completedFuture(this.usermap.get(uuid));
        }
        return this.plugin.supplyAsync(() -> this.plugin.getDatabase().getPlayer(uuid).map(teamPlayer -> {
            this.usermap.put(teamPlayer.getUuid(), (OnlinePlayer)teamPlayer);
            return teamPlayer;
        }).orElseGet(() -> {
            if (name == null) {
                throw new IllegalArgumentException("Player " + String.valueOf(uuid) + " not found");
            }
            OnlinePlayer onlinePlayer = new OnlinePlayer(uuid, name, Preferences.getDefaults());
            this.plugin.getDatabase().createPlayer(onlinePlayer);
            this.usermap.put(uuid, onlinePlayer);
            return onlinePlayer;
        })).whenComplete((result, ex) -> {
            if (ex != null) {
                this.plugin.log(Level.WARNING, "Error while trying to get player", (Throwable)ex);
            }
        });
    }

    public void updatePlayerName(Player player) {
        UUID uuid = player.getUniqueId();
        String newPlayerName = player.getName();
        OnlinePlayer onlinePlayer = this.usermap.get(uuid);
        onlinePlayer.setLastPlayerName(newPlayerName);
        this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(onlinePlayer));
        this.usermap.replace(uuid, onlinePlayer);
    }

    public void updatePlayer(OnlinePlayer onlinePlayer) {
        this.plugin.runAsync(task -> this.plugin.getDatabase().updatePlayer(onlinePlayer));
        this.usermap.replace(onlinePlayer.getUuid(), onlinePlayer);
    }

    public boolean canUseDialogs(@NotNull Player player) {
        return this.plugin.getViaVersionHook() != null && this.plugin.getViaVersionHook().getPlayerVersion(player) >= 771 && this.plugin.getSettings().isUseDialogs();
    }

    public boolean canAddComments(@NotNull Player player, @NotNull Report report) {
        return player.hasPermission("ultimatereports.reports.manage") || player.getUniqueId().equals(report.getReporter());
    }

    public boolean canAddComments(@NotNull Player player, int id) {
        return this.plugin.getReportsManager().getReportById(id).map(r -> player.hasPermission("ultimatereports.reports.manage") || player.getUniqueId().equals(r.getReporter())).orElse(false);
    }

    public Player getRandomPlayer() {
        return Bukkit.getOnlinePlayers().stream().findFirst().orElse(null);
    }

    @Generated
    public Map<UUID, OnlinePlayer> getUsermap() {
        return this.usermap;
    }

    @Generated
    public Map<String, List<User>> getGlobalUserList() {
        return this.globalUserList;
    }

    @Generated
    public ConcurrentMap<UUID, Player> getOnlineUserMap() {
        return this.onlineUserMap;
    }
}

