/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.models;

import dev.xf3d3.ultimatereports.libraries.gson.annotations.Expose;
import dev.xf3d3.ultimatereports.libraries.gson.annotations.SerializedName;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.ApiStatus;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.entity.Player;

public class Comment {
    @Expose
    private long timestamp;
    @Expose
    private UUID id;
    @Expose
    private UUID author;
    @Expose
    @SerializedName(value="author_name")
    private String authorName;
    @Expose
    private String message;
    @Expose
    private MessageStatus status;
    @Expose
    @SerializedName(value="discord_message_id")
    @Nullable
    private String discordMessageId;

    @NotNull
    @ApiStatus.Internal
    public static Comment create(@NotNull Player author, @NotNull String message) {
        return Comment.builder().author(author.getUniqueId()).authorName(author.getName()).message(message).build();
    }

    @Generated
    private static long $default$timestamp() {
        return System.currentTimeMillis();
    }

    @Generated
    private static UUID $default$id() {
        return UUID.randomUUID();
    }

    @Generated
    private static MessageStatus $default$status() {
        return MessageStatus.NOT_READ;
    }

    @Generated
    public static CommentBuilder builder() {
        return new CommentBuilder();
    }

    @Generated
    private Comment() {
        this.timestamp = Comment.$default$timestamp();
        this.id = Comment.$default$id();
        this.status = Comment.$default$status();
    }

    @Generated
    private Comment(long timestamp, UUID id, UUID author, String authorName, String message, MessageStatus status, @Nullable String discordMessageId) {
        this.timestamp = timestamp;
        this.id = id;
        this.author = author;
        this.authorName = authorName;
        this.message = message;
        this.status = status;
        this.discordMessageId = discordMessageId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Comment)) {
            return false;
        }
        Comment other = (Comment)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Comment;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public void setId(UUID id) {
        this.id = id;
    }

    @Generated
    public UUID getAuthor() {
        return this.author;
    }

    @Generated
    public void setAuthor(UUID author) {
        this.author = author;
    }

    @Generated
    public String getAuthorName() {
        return this.authorName;
    }

    @Generated
    public void setAuthorName(String authorName) {
        this.authorName = authorName;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public MessageStatus getStatus() {
        return this.status;
    }

    @Generated
    public void setStatus(MessageStatus status) {
        this.status = status;
    }

    @Nullable
    @Generated
    public String getDiscordMessageId() {
        return this.discordMessageId;
    }

    @Generated
    public void setDiscordMessageId(@Nullable String discordMessageId) {
        this.discordMessageId = discordMessageId;
    }

    @Generated
    public static class CommentBuilder {
        @Generated
        private boolean timestamp$set;
        @Generated
        private long timestamp$value;
        @Generated
        private boolean id$set;
        @Generated
        private UUID id$value;
        @Generated
        private UUID author;
        @Generated
        private String authorName;
        @Generated
        private String message;
        @Generated
        private boolean status$set;
        @Generated
        private MessageStatus status$value;
        @Generated
        private String discordMessageId;

        @Generated
        CommentBuilder() {
        }

        @Generated
        public CommentBuilder timestamp(long timestamp) {
            this.timestamp$value = timestamp;
            this.timestamp$set = true;
            return this;
        }

        @Generated
        public CommentBuilder id(UUID id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @Generated
        public CommentBuilder author(UUID author) {
            this.author = author;
            return this;
        }

        @Generated
        public CommentBuilder authorName(String authorName) {
            this.authorName = authorName;
            return this;
        }

        @Generated
        public CommentBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public CommentBuilder status(MessageStatus status) {
            this.status$value = status;
            this.status$set = true;
            return this;
        }

        @Generated
        public CommentBuilder discordMessageId(@Nullable String discordMessageId) {
            this.discordMessageId = discordMessageId;
            return this;
        }

        @Generated
        public Comment build() {
            long timestamp$value = this.timestamp$value;
            if (!this.timestamp$set) {
                timestamp$value = Comment.$default$timestamp();
            }
            UUID id$value = this.id$value;
            if (!this.id$set) {
                id$value = Comment.$default$id();
            }
            MessageStatus status$value = this.status$value;
            if (!this.status$set) {
                status$value = Comment.$default$status();
            }
            return new Comment(timestamp$value, id$value, this.author, this.authorName, this.message, status$value, this.discordMessageId);
        }

        @Generated
        public String toString() {
            return "Comment.CommentBuilder(timestamp$value=" + this.timestamp$value + ", id$value=" + String.valueOf(this.id$value) + ", author=" + String.valueOf(this.author) + ", authorName=" + this.authorName + ", message=" + this.message + ", status$value=" + String.valueOf((Object)this.status$value) + ", discordMessageId=" + this.discordMessageId + ")";
        }
    }

    public static enum MessageStatus {
        READ,
        NOT_READ;


        public static Optional<MessageStatus> parse(@NotNull String string) {
            return Arrays.stream(MessageStatus.values()).filter(operation -> operation.name().equalsIgnoreCase(string)).findFirst();
        }
    }
}

