/*
 * Decompiled with CFR 0.152.
 */
package dev.xf3d3.ultimatereports.models;

import dev.xf3d3.ultimatereports.UltimateReports;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.NotNull;
import dev.xf3d3.ultimatereports.libraries.jetbrains.annotations.Nullable;
import dev.xf3d3.ultimatereports.models.Preferences;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class OnlinePlayer {
    private UUID uuid;
    private String lastPlayerName;
    private Preferences preferences;

    public OnlinePlayer(@NotNull UUID UUID2, @NotNull String playerName, @Nullable Preferences preferences) {
        this.uuid = UUID2;
        this.lastPlayerName = playerName;
        this.preferences = preferences != null ? preferences : Preferences.getDefaults();
    }

    public long addCoolDown(@NotNull UltimateReports plugin, long minutes) {
        long now = System.currentTimeMillis();
        long currentCooldown = this.getPreferences().getCooldown();
        long durationToAdd = TimeUnit.MINUTES.toMillis(minutes);
        long newExpirationTime = currentCooldown > now ? currentCooldown + durationToAdd : now + durationToAdd;
        this.getPreferences().setCooldown(newExpirationTime);
        plugin.getUsersManager().updatePlayer(this);
        return newExpirationTime;
    }

    public boolean isOnCooldown() {
        return this.getPreferences().getCooldown() > System.currentTimeMillis();
    }

    public long getRemainingTime() {
        long now = System.currentTimeMillis();
        long cooldown = this.getPreferences().getCooldown();
        if (cooldown <= now) {
            return 0L;
        }
        return cooldown - now;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public String getLastPlayerName() {
        return this.lastPlayerName;
    }

    @Generated
    public void setLastPlayerName(String lastPlayerName) {
        this.lastPlayerName = lastPlayerName;
    }

    @Generated
    public Preferences getPreferences() {
        return this.preferences;
    }

    @Generated
    public void setPreferences(Preferences preferences) {
        this.preferences = preferences;
    }
}

